/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MinorDateFormat
extends SimpleDateFormat {
    private TimeGranularity granularity;
    private String[] tinyDays;
    private String[] tinyMonths;
    private DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();

    public MinorDateFormat(String pattern, TimeGranularity granularity) {
        super(pattern);
        int i;
        if (granularity == null) {
            throw new IllegalArgumentException("granularity can not be NULL");
        }
        this.granularity = granularity;
        this.tinyMonths = this.dateFormatSymbols.getShortMonths();
        for (i = 0; i < this.tinyMonths.length; ++i) {
            if (this.tinyMonths[i].length() <= 0) continue;
            this.tinyMonths[i] = this.tinyMonths[i].substring(0, 1);
        }
        this.tinyDays = this.dateFormatSymbols.getShortWeekdays();
        for (i = 0; i < this.tinyDays.length; ++i) {
            if (this.tinyDays[i].length() <= 0) continue;
            this.tinyDays[i] = this.tinyDays[i].substring(0, 1);
        }
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        if (date == null) {
            throw new IllegalArgumentException("date can not be NULL");
        }
        Calendar c = Calendar.getInstance(this.getTimeZone());
        c.setTime(date);
        switch (this.granularity) {
            case MONTH_TINY: {
                return toAppendTo.append(this.tinyMonths[c.get(2)]);
            }
            case DAY_TINY: {
                return toAppendTo.append(this.tinyDays[c.get(7)]);
            }
        }
        return super.format(date, toAppendTo, pos);
    }
}

