/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.selector.ActionSelector;
import com.dlsc.flexgantt.swing.selector.BookmarksSelector;
import com.dlsc.flexgantt.swing.selector.ColumnChooserSelector;
import com.dlsc.flexgantt.swing.selector.GranularitySelector;
import com.dlsc.flexgantt.swing.selector.GridSelector;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.LayerSelector;
import com.dlsc.flexgantt.swing.selector.OverviewSelector;
import com.dlsc.flexgantt.swing.selector.PagingSelector;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.selector.SpreadsheetSelector;
import com.dlsc.flexgantt.swing.selector.TimeGranularityGotoSelector;
import com.dlsc.flexgantt.swing.selector.TimeGranularityHorizonSelector;
import com.dlsc.flexgantt.swing.selector.TimeZoneSelector;
import javax.swing.JComponent;

public class TimeGranularitySelectorFactory
implements ISelectorFactory {
    private static TimeGranularitySelectorFactory instance;

    protected TimeGranularitySelectorFactory() {
    }

    public static TimeGranularitySelectorFactory getInstance() {
        if (instance == null) {
            instance = new TimeGranularitySelectorFactory();
        }
        return instance;
    }

    @Override
    public Selector createSelector(AbstractGanttChart gc, JComponent parentComponent, ISelectorFactory.SelectorID id) {
        switch (id) {
            case ACTIONS: {
                return new ActionSelector(parentComponent, gc);
            }
            case COLUMNS: {
                return new ColumnChooserSelector(parentComponent, gc);
            }
            case GOTO: {
                return new TimeGranularityGotoSelector(parentComponent, gc);
            }
            case TIMEZONE: {
                return new TimeZoneSelector(parentComponent, gc);
            }
            case PAGES: {
                return new PagingSelector(parentComponent, gc);
            }
            case LAYERS: {
                return new LayerSelector(parentComponent, gc.getLayerContainers());
            }
            case OVERVIEW: {
                return new OverviewSelector(parentComponent, gc.getLayerContainers());
            }
            case GRANULARITY: {
                return new GranularitySelector(parentComponent, gc.getDateline());
            }
            case HORIZON: {
                return new TimeGranularityHorizonSelector(parentComponent, gc.getDateline());
            }
            case SPREADSHEET: {
                return new SpreadsheetSelector(parentComponent, gc);
            }
        }
        throw new IllegalArgumentException("unsupported selector type (id = " + (Object)((Object)id) + ") for Gantt charts");
    }

    @Override
    public Selector createSelector(LayerContainer layerContainer, JComponent parentComponent, ISelectorFactory.SelectorID id) {
        switch (id) {
            case BOOKMARKS: {
                return new BookmarksSelector(parentComponent, layerContainer);
            }
        }
        throw new IllegalArgumentException("unsupported selector type (id = " + (Object)((Object)id) + ") for layer containers");
    }

    @Override
    public Selector createSelector(IGridComponent gridComponent, JComponent parentComponent, ISelectorFactory.SelectorID id) {
        switch (id) {
            case GRID: {
                return new GridSelector(parentComponent, gridComponent);
            }
        }
        throw new IllegalArgumentException("unsupported selector type (id = " + (Object)((Object)id) + ") for the given grid component");
    }
}

