/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.icons.BlankIcon;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SpreadsheetSelector
extends Selector {
    private AbstractGanttChart ganttChart;

    public SpreadsheetSelector(JComponent comp, AbstractGanttChart ganttChart) {
        super(Messages.getString("SpreadsheetSelector.TITLE"), comp, Selector.Location.ABOVE);
        this.ganttChart = ganttChart;
        this.setContentComponent(new SpreadsheetPanel());
    }

    private class SpreadsheetPanel
    extends JPanel
    implements ListSelectionListener {
        private JList list;
        private int focusedRow = -1;
        private ISpreadsheet noSpreadsheet = new NoSpreadsheet();

        protected SpreadsheetPanel() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.list = new JList();
            this.list.setCellRenderer(new SpreadsheetListCellRenderer());
            this.list.setOpaque(false);
            this.list.setSelectionMode(0);
            this.list.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.list.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int row = SpreadsheetPanel.this.list.locationToIndex(e.getPoint());
                    if (row != SpreadsheetPanel.this.focusedRow) {
                        SpreadsheetPanel.this.focusedRow = row;
                        SpreadsheetPanel.this.repaint();
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    SpreadsheetPanel.this.focusedRow = -1;
                    SpreadsheetPanel.this.repaint();
                }
            });
            JScrollPane scroll = new JScrollPane(this.list);
            scroll.setBorder(null);
            scroll.setOpaque(false);
            scroll.setViewportBorder(null);
            scroll.getViewport().setBorder(null);
            scroll.getViewport().setOpaque(false);
            scroll.setVerticalScrollBarPolicy(21);
            this.add("Center", scroll);
            this.updateList();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ISpreadsheet spreadsheet = (ISpreadsheet)this.list.getSelectedValue();
                if (spreadsheet.equals(this.noSpreadsheet)) {
                    SpreadsheetSelector.this.ganttChart.setActiveSpreadsheet(null);
                } else {
                    SpreadsheetSelector.this.ganttChart.setActiveSpreadsheet(spreadsheet);
                }
                SpreadsheetSelector.this.setVisible(false);
            }
        }

        private void updateList() {
            this.list.getSelectionModel().removeListSelectionListener(this);
            DefaultListModel<ISpreadsheet> listModel = new DefaultListModel<ISpreadsheet>();
            IGanttChartModel ganttModel = SpreadsheetSelector.this.ganttChart.getModel();
            Iterator<ISpreadsheet> spreadsheets = ganttModel.getSpreadsheets();
            listModel.removeAllElements();
            listModel.addElement(this.noSpreadsheet);
            while (spreadsheets.hasNext()) {
                listModel.addElement(spreadsheets.next());
            }
            this.list.setModel(listModel);
            this.list.setVisibleRowCount(listModel.getSize());
            ISpreadsheet active = SpreadsheetSelector.this.ganttChart.getActiveSpreadsheet();
            if (active != null) {
                this.list.setSelectedValue(active, true);
            } else {
                this.list.setSelectedValue(this.noSpreadsheet, true);
            }
            this.list.getSelectionModel().addListSelectionListener(this);
        }

        class NoSpreadsheet
        implements ISpreadsheet {
            NoSpreadsheet() {
            }

            @Override
            public String getName() {
                return "Off";
            }

            @Override
            public IGranularity<?> getGranularity() {
                return null;
            }

            @Override
            public int getCellWidth() {
                return 0;
            }

            @Override
            public Class getDefaultValueType() {
                return null;
            }
        }

        private class SpreadsheetListCellRenderer
        extends JLabel
        implements ListCellRenderer {
            private Icon selectionIcon;
            private Icon notSelectedIcon;
            private boolean focused;

            protected SpreadsheetListCellRenderer() {
                this.setOpaque(false);
                this.selectionIcon = IconRegistry.getIcon(IconId.SELECTION_INDICATOR);
                this.notSelectedIcon = new BlankIcon(this.selectionIcon.getIconWidth(), this.selectionIcon.getIconHeight());
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ISpreadsheet spreadsheet = (ISpreadsheet)value;
                this.setText(spreadsheet.getName());
                this.setForeground(Color.BLACK);
                if (isSelected) {
                    this.setIcon(this.selectionIcon);
                } else {
                    this.setIcon(this.notSelectedIcon);
                }
                this.focused = index == SpreadsheetPanel.this.focusedRow;
                this.setOpaque(this.focused);
                if (this.focused) {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.BLACK);
                }
                return this;
            }
        }
    }
}

