/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;

public class DefaultEventObjectRenderer
extends JLabel
implements ITimelineObjectRenderer {
    private final JLabel label;
    private Icon icon;
    private Icon selectedIcon;
    private boolean selected;
    private TimelineObjectPath timelineObjectPath;

    public DefaultEventObjectRenderer(Icon icon, Icon selectedIcon) {
        if (icon == null) {
            throw new IllegalArgumentException("icon can not be NULL");
        }
        if (selectedIcon == null) {
            throw new IllegalArgumentException("selected icon can not be NULL");
        }
        this.icon = icon;
        this.selectedIcon = selectedIcon;
        this.label = new JLabel();
        this.setOpaque(false);
        this.setBorder(null);
    }

    public DefaultEventObjectRenderer() {
        this(IconRegistry.getIcon(IconId.EVENT), IconRegistry.getIcon(IconId.EVENT));
    }

    @Override
    public Component getTimelineObjectRendererComponent(TimelineObjectLayer layer, TimelineObjectPath path, boolean selected, boolean focus, boolean highlighted, int row) {
        this.timelineObjectPath = path;
        this.selected = selected;
        this.label.setIcon(this.getIcon());
        if (selected && this.getSelectedIcon() != null) {
            this.label.setIcon(this.getSelectedIcon());
        }
        return this;
    }

    @Override
    public Insets getTimelineObjectRendererInsets(int x, int y, int width, int height) {
        Icon selectedIcon;
        Icon icon = this.getIcon();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        if (this.selected && (selectedIcon = this.getSelectedIcon()) != null) {
            w = selectedIcon.getIconWidth();
            h = selectedIcon.getIconHeight();
        }
        return new Insets(height / 2 - h / 2, -(w / 2), height / 2 - h / 2, -(w / 2));
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon icon) {
        this.selectedIcon = icon;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public TimelineObjectPath getTimelineObjectPath() {
        return this.timelineObjectPath;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

