/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class TimeNowLayer
extends AbstractSystemLayer
implements PropertyChangeListener {
    public TimeNowLayer(LayerContainer lc) {
        super("Time Now", lc);
        Timeline timeline = this.getGanttChart().getTimeline();
        Eventline eventline = timeline.getEventline();
        eventline.addPropertyChangeListener(this);
    }

    @Override
    protected void paintLayer(Graphics g) {
        super.paintLayer(g);
        Rectangle clip = g.getClipBounds();
        long now = this.getEventline().getTimeNow();
        int x = this.getDateline().getTimeLocation(now);
        if (x >= clip.x && x < clip.x + clip.width) {
            this.paintTimeNow(g, x);
        }
    }

    protected void paintTimeNow(Graphics g, int x) {
        int start;
        Graphics2D g2d = (Graphics2D)g;
        Composite comp = g2d.getComposite();
        Rectangle clip = g.getClipBounds();
        g2d.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        for (int y = start = clip.y - clip.y % 16; y < clip.y + clip.height; y += 16) {
            g.setColor(Color.RED.brighter());
            g.drawLine(x - 1, y, x - 1, y + 7);
            g.drawLine(x, y, x, y + 7);
            g.drawLine(x + 1, y, x + 1, y + 7);
            g.setColor(Color.RED.darker());
            g.drawLine(x - 1, y + 7, x - 1, y + 15);
            g.drawLine(x, y + 7, x, y + 15);
            g.drawLine(x + 1, y + 7, x + 1, y + 15);
        }
        g2d.setComposite(comp);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (evt.getSource() == this.getEventline() && property.equals("timeNow")) {
            this.repaint();
        }
    }
}

