/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.swing.layer.ILayerContainerSelectionModel;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;

public class SelectionLayer
extends AbstractSystemLayer {
    private Paint selectionPaint = ColorUtil.getSelectionBackground();

    public SelectionLayer(LayerContainer lc) {
        super("Selection", lc);
        this.setAlpha(0.7f);
    }

    @Override
    public boolean isVisible() {
        ILayerContainerSelectionModel selectionModel = this.layerContainer.getSelectionModel();
        return !selectionModel.isEmpty();
    }

    @Override
    protected void paintLayer(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle clip = g.getClipBounds();
        int startRow = this.getStartRow();
        if (startRow != -1) {
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
            Dateline dateline = this.getDateline();
            long s = dateline.getTimeAt(clip.x);
            long e = dateline.getTimeAt(clip.x + clip.width);
            TimeSpan clipSpan = new TimeSpan(s, e);
            ILayerContainerSelectionModel selectionModel = this.layerContainer.getSelectionModel();
            if (!selectionModel.isEmpty()) {
                List<TreeTableNode> nodes = this.layerContainer.getClipNodes();
                for (TreeTableNode node : nodes) {
                    int y = node.getY();
                    int rowHeight = node.getHeight();
                    Object modelNode = node.getModelNode();
                    if (selectionModel.isEmpty(modelNode)) continue;
                    Iterator<ITimeSpan> selectionIter = selectionModel.getSelectedTimeSpans(modelNode, clipSpan);
                    while (selectionIter.hasNext()) {
                        g2d.setPaint(this.selectionPaint);
                        ITimeSpan span = selectionIter.next();
                        int x1 = dateline.getTimeLocation(span.getStartTime());
                        int x2 = dateline.getTimeLocation(span.getEndTime());
                        g2d.fillRect(x1, y, x2 - x1, rowHeight);
                    }
                }
            }
            g2d.setComposite(comp);
        }
        super.paintLayer(g);
    }

    public Paint getSelectionPaint() {
        return this.selectionPaint;
    }

    public void setSelectionPaint(Paint paint) {
        this.selectionPaint = paint;
    }
}

