/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultResourceNode;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.DefaultResourceRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.DefaultRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.IRowRenderer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;

public class RowLayer
extends AbstractSystemLayer
implements MouseMotionListener,
MouseListener {
    private int focusedRow = -1;
    private Map<Class, IRowRenderer> rowRendererMap = new HashMap<Class, IRowRenderer>(10);
    private Map<Class, IRowRenderer> rowRendererCache = new HashMap<Class, IRowRenderer>(10);
    private boolean paintingFocus;

    public RowLayer(LayerContainer lc) {
        super("Rows", lc);
        this.setRowRenderer(Object.class, new DefaultRowRenderer());
        this.setRowRenderer(DefaultResourceNode.class, new DefaultResourceRowRenderer());
    }

    @Override
    protected void paintLayer(Graphics g) {
        List<TreeTableNode> treeTableNodes;
        super.paintLayer(g);
        Rectangle clip = g.getClipBounds();
        int startNode = this.getStartRow();
        if (startNode != -1 && (treeTableNodes = this.getTreeTable().getTreeTableNodes()) != null && treeTableNodes.size() > 0) {
            Dateline dateline = this.getDateline();
            long s = dateline.getTimeAt(clip.x);
            long e = dateline.getTimeAt(clip.x + clip.width);
            TimeSpan clipSpan = new TimeSpan(s, e);
            int y = treeTableNodes.get(startNode).getY();
            int clipLine = 0;
            for (int row = startNode; row < treeTableNodes.size(); ++row) {
                TreeTableNode node = treeTableNodes.get(row);
                int rowHeight = node.getHeight();
                Object modelNode = node.getModelNode();
                TreePath path = node.getPath();
                boolean selected = this.getTreeTable().getSelectionModel().isPathSelected(path);
                IRowRenderer renderer = this.getRowRenderer(modelNode.getClass());
                if (renderer == null) continue;
                boolean focus = row == this.focusedRow;
                Component comp = renderer.getRowRendererComponent(this, modelNode, selected, row, clipSpan, focus);
                Rectangle bounds = new Rectangle(0, y, this.layerContainer.getWidth(), rowHeight);
                g.clipRect(0, Math.max(clipLine, y), this.getWidth(), this.getHeight());
                this.layerContainer.getRendererPane().paintComponent(g, comp, this.layerContainer, bounds);
                g.setClip(clip);
                if ((y += rowHeight) > clip.y + clip.height) break;
                TreeTable table = this.getTreeTable();
                if (node != table.getAnimationNode()) continue;
                clipLine = y;
                y -= (int)((double)node.getTotalChildrenHeight() * (1.0 - table.getAnimationPercentage()));
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int row = this.getTreeTable().getRowAt(evt.getY());
        if (this.focusedRow != row) {
            this.layerContainer.repaintRow(this.focusedRow);
            this.layerContainer.repaintRow(row);
            this.focusedRow = row;
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.layerContainer.repaintRow(this.focusedRow);
        this.focusedRow = -1;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    public void setRowRenderer(Class treeNodeType, IRowRenderer renderer) {
        if (treeNodeType == null) {
            throw new IllegalArgumentException("the tree node type can not be NULL");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("the row renderer can not be NULL");
        }
        this.rowRendererCache.clear();
        this.rowRendererMap.put(treeNodeType, renderer);
    }

    public IRowRenderer getRowRenderer(Class treeNodeType) {
        if (treeNodeType == null) {
            return null;
        }
        IRowRenderer rowRenderer = this.rowRendererCache.get(treeNodeType);
        if (rowRenderer != null) {
            return rowRenderer;
        }
        rowRenderer = this.rowRendererMap.get(treeNodeType);
        if (rowRenderer == null) {
            rowRenderer = this.getRowRenderer(treeNodeType.getSuperclass());
        }
        this.rowRendererCache.put(treeNodeType, rowRenderer);
        return rowRenderer;
    }

    public Map<Class, IRowRenderer> getRowRendererMap() {
        return this.rowRendererMap;
    }

    public void setRowRendererMap(Map<Class, IRowRenderer> map) {
        if (map == null) {
            throw new IllegalArgumentException("row renderer map can not be NULL");
        }
        this.rowRendererMap = map;
    }

    public boolean isPaintingFocus() {
        return this.paintingFocus;
    }

    public void setPaintingFocus(boolean paintingFocus) {
        this.paintingFocus = paintingFocus;
        if (paintingFocus) {
            this.layerContainer.addMouseListener(this);
            this.layerContainer.addMouseMotionListener(this);
        } else {
            this.layerContainer.removeMouseListener(this);
            this.layerContainer.removeMouseMotionListener(this);
        }
    }
}

