/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.model.gantt.DefaultRelationship;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IRelationshipPolicy;
import com.dlsc.flexgantt.policy.layer.ISelectionPolicy;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.DefaultRelationshipRenderer;
import com.dlsc.flexgantt.swing.layer.system.DefaultRelationshipSelectionModel;
import com.dlsc.flexgantt.swing.layer.system.IRelationshipRenderer;
import com.dlsc.flexgantt.swing.layer.system.IRelationshipSelectionModel;
import com.dlsc.flexgantt.swing.layer.system.IRelationshipSelectionModelListener;
import com.dlsc.flexgantt.swing.layer.system.RelationshipSelectionEvent;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class RelationshipLayer
extends AbstractSystemLayer
implements MouseListener,
MouseMotionListener,
IRelationshipSelectionModelListener,
IGanttChartModelListener,
PropertyChangeListener {
    private Map<Class<? extends IRelationship>, IRelationshipRenderer> rendererMap;
    private Map<Class<? extends IRelationship>, IRelationshipRenderer> rendererCache;
    private Map<GeneralPath, IRelationship> pathRelationshipMap;
    private boolean debugRelationshipBounds;
    private IRelationshipSelectionModel selectionModel = new DefaultRelationshipSelectionModel();
    private IRelationship focusedRelationship;

    public RelationshipLayer(LayerContainer lc) {
        super("Relationship", lc);
        this.selectionModel.addRelationshipSelectionModelListener(this);
        this.rendererMap = new HashMap<Class<? extends IRelationship>, IRelationshipRenderer>(10);
        this.rendererCache = new HashMap<Class<? extends IRelationship>, IRelationshipRenderer>(10);
        this.pathRelationshipMap = new HashMap<GeneralPath, IRelationship>();
        this.setRelationshipRenderer(DefaultRelationship.class, new DefaultRelationshipRenderer());
        lc.addMouseListener(this);
        lc.addMouseMotionListener(this);
        lc.addPropertyChangeListener(this);
    }

    public IRelationshipSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(IRelationshipSelectionModel model) {
        if (model == null) {
            throw new IllegalArgumentException("selection model can not be NULL");
        }
        this.selectionModel.removeRelationshipSelectionModelListener(this);
        this.selectionModel = model;
        this.selectionModel.addRelationshipSelectionModelListener(this);
    }

    @Override
    public boolean isVisible() {
        return this.ganttChart.isRelationsVisible();
    }

    @Override
    protected void paintLayer(Graphics g) {
        super.paintLayer(g);
        this.pathRelationshipMap.clear();
        int w = this.layerContainer.getWidth();
        int h = this.layerContainer.getHeight();
        IGanttChartModel model = this.getModel();
        Iterator iter = model.getRelationships();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        while (iter.hasNext()) {
            IRelationship r = iter.next();
            if (!this.isVisible(r) || r == this.focusedRelationship) continue;
            this.paintRelationship(g2d, w, h, r, model);
        }
        if (this.focusedRelationship != null) {
            this.paintRelationship(g2d, w, h, this.focusedRelationship, model);
        }
        g2d.dispose();
    }

    private boolean isVisible(IRelationship rel) {
        if (rel == null) {
            return false;
        }
        TreeTable table = this.getTreeTable();
        ILayer sourceLayer = rel.getSourcePath().getLayer();
        ILayer targetLayer = rel.getTargetPath().getLayer();
        if (sourceLayer.isFeatureEnabled(ILayer.Feature.RELATIONSHIPS) && targetLayer.isFeatureEnabled(ILayer.Feature.RELATIONSHIPS)) {
            boolean visible = this.layerContainer.isLayerVisible(sourceLayer) && this.layerContainer.isLayerVisible(targetLayer) && table.isTreePathExpanded(rel.getSourcePath()) && table.isTreePathExpanded(rel.getTargetPath()) && !this.isCollapsing(rel);
            return visible;
        }
        return false;
    }

    private boolean isCollapsing(IRelationship rel) {
        TreeTable table = this.getTreeTable();
        TreeTableNode animatedNode = table.getAnimationNode();
        if (animatedNode != null) {
            int firstRow = animatedNode.getRow() + 1;
            int lastRow = firstRow + animatedNode.getTotalChildrenCount() - 1;
            TimelineObjectPath sourcePath = rel.getSourcePath();
            int sourceRow = table.getRowForPath(sourcePath);
            if (sourceRow >= firstRow && sourceRow <= lastRow) {
                return true;
            }
            TimelineObjectPath targetPath = rel.getTargetPath();
            int targetRow = table.getRowForPath(targetPath);
            if (targetRow >= firstRow && targetRow <= lastRow) {
                return true;
            }
        }
        return false;
    }

    protected void paintRelationship(Graphics g, int w, int h, IRelationship relationship, IGanttChartModel model) {
        IRelationshipRenderer renderer = this.getRelationshipRenderer(relationship.getClass());
        boolean selected = this.selectionModel.isSelected(relationship);
        boolean focused = relationship == this.focusedRelationship;
        GeneralPath path = renderer.drawRelationship(this, g, relationship, focused, selected);
        this.pathRelationshipMap.put(path, relationship);
        if (this.debugRelationshipBounds) {
            g.setColor(Color.GREEN);
            ((Graphics2D)g).draw(path);
            this.paintPathPoints(g, path);
        }
    }

    private void paintPathPoints(Graphics g, GeneralPath path) {
        PathIterator iter = path.getPathIterator(null);
        g.setColor(Color.RED);
        double[] coordinates = new double[6];
        while (!iter.isDone()) {
            iter.currentSegment(coordinates);
            g.drawOval((int)coordinates[0] - 2, (int)coordinates[1] - 2, 4, 4);
            iter.next();
        }
    }

    public void setRelationshipRenderer(Class<? extends IRelationship> relationshipType, IRelationshipRenderer renderer) {
        if (relationshipType == null) {
            throw new IllegalArgumentException("the relationship type can not be NULL");
        }
        this.rendererCache.clear();
        this.rendererMap.put(relationshipType, renderer);
    }

    public IRelationshipRenderer getRelationshipRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        IRelationshipRenderer renderer = this.rendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.rendererMap.get(cl);
        if (renderer != null) {
            this.rendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getRelationshipRenderer(cl.getSuperclass());
        this.rendererCache.put(cl, renderer);
        return renderer;
    }

    public List<IRelationship> getRelationshipsAt(int x, int y) {
        ArrayList<IRelationship> result = new ArrayList<IRelationship>();
        for (GeneralPath path : this.pathRelationshipMap.keySet()) {
            Rectangle bounds = path.getBounds();
            bounds.grow(2, 2);
            if (!bounds.intersects(x, y, 1.0, 1.0) || !this.mouseHitSegment(path, x, y)) continue;
            result.add(this.pathRelationshipMap.get(path));
        }
        return result;
    }

    private boolean mouseHitSegment(GeneralPath path, int x, int y) {
        Point2D.Double loc = new Point2D.Double(x, y);
        PathIterator iter = path.getPathIterator(null);
        double[] coordinates = new double[6];
        Point2D.Double firstPoint = null;
        while (!iter.isDone()) {
            iter.currentSegment(coordinates);
            if (firstPoint == null) {
                firstPoint = new Point2D.Double(coordinates[0], coordinates[1]);
            } else {
                Point2D.Double secondPoint = new Point2D.Double(coordinates[0], coordinates[1]);
                Line2D.Double line = new Line2D.Double(firstPoint, secondPoint);
                double distance = line.ptSegDist(loc);
                if (distance <= 2.0) {
                    return true;
                }
                firstPoint = secondPoint;
            }
            iter.next();
        }
        return false;
    }

    public void setDebugRelationshipBounds(boolean debug) {
        this.debugRelationshipBounds = debug;
    }

    public boolean isDebugRelationshipBounds() {
        return this.debugRelationshipBounds;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isVisible() && !this.layerContainer.isPopupShowing() && !e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && !e.isAltDown()) {
            this.performSelection(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        IRelationship lastFocused = this.focusedRelationship;
        List<IRelationship> rel = this.getRelationshipsAt(e.getX(), e.getY());
        this.focusedRelationship = !rel.isEmpty() ? rel.get(0) : null;
        if (this.focusedRelationship != lastFocused) {
            this.repaint();
        }
    }

    private void performSelection(MouseEvent e) {
        if (!this.layerContainer.isIgnoringTreeTableSelection()) {
            this.getTreeTable().clearSelection();
        }
        List<IRelationship> relationships = this.getRelationshipsAt(e.getX(), e.getY());
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (!relationships.isEmpty()) {
            IRelationship rel = relationships.get(0);
            IGanttChartModel model = this.getModel();
            ISelectionPolicy sp = this.getLayerPolicyProvider().getPolicy(ISelectionPolicy.class);
            if (sp.isSelectable(rel, model)) {
                boolean selected = this.selectionModel.isSelected(rel);
                if (!selected) {
                    if (!e.isShiftDown() && (e.getModifiers() & mask) == 0) {
                        this.selectionModel.clearSelection();
                    }
                    ArrayList<IRelationship> list = new ArrayList<IRelationship>();
                    list.add(rel);
                    this.selectionModel.addSelection(list);
                } else if (e.isShiftDown() || (e.getModifiers() & mask) != 0) {
                    ArrayList<IRelationship> list = new ArrayList<IRelationship>();
                    list.add(rel);
                    this.selectionModel.removeSelection(list);
                }
            }
            e.consume();
        } else if (!this.selectionModel.isEmpty() && !e.isShiftDown() && (e.getModifiers() & mask) == 0) {
            this.selectionModel.clearSelection();
        }
    }

    @Override
    public void valueChanged(RelationshipSelectionEvent evt) {
        this.repaint();
    }

    public Collection<IRelationship> getSelectedRelationships() {
        return this.selectionModel.getSelection();
    }

    public void deleteSelectedRelationships() {
        Collection<IRelationship> selection = this.getSelectedRelationships();
        if (selection != null && selection.size() > 0) {
            IPolicyProvider pp = this.layerContainer.getPolicyProvider();
            IRelationshipPolicy ep = pp.getPolicy(IRelationshipPolicy.class);
            IGanttChartModel model = this.getModel();
            ArrayList<IRelationship> deletedList = new ArrayList<IRelationship>();
            for (IRelationship rel : selection) {
                if (!ep.isDeletable(rel, model)) continue;
                deletedList.add(rel);
            }
            if (deletedList.size() > 0) {
                ICommand cmd = ep.getDeleteRelationshipsCommand(deletedList, model);
                this.ganttChart.commandExecute(cmd);
            }
        }
    }

    @Override
    public void ganttChartChanged(GanttChartModelEvent evt) {
        if (evt.getId().equals((Object)GanttChartModelEvent.ID.RELATIONSHIP_REMOVED)) {
            Collection<IRelationship> coll = evt.getRelationships();
            if (coll != null) {
                this.selectionModel.removeSelection(coll);
            }
            for (IRelationship rel : coll) {
                if (rel != this.focusedRelationship) continue;
                this.focusedRelationship = null;
                this.repaint();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.layerContainer) && evt.getPropertyName().equals("model")) {
            IGanttChartModel oldModel = (IGanttChartModel)evt.getOldValue();
            IGanttChartModel newModel = (IGanttChartModel)evt.getNewValue();
            if (oldModel != null) {
                oldModel.removeGanttChartModelListener(this);
            }
            if (newModel != null) {
                newModel.addGanttChartModelListener(this);
            }
        }
    }

    public Map<Class<? extends IRelationship>, IRelationshipRenderer> getRelationshipRendererMap() {
        return this.rendererMap;
    }

    public void setRelationshipRendererMap(Map<Class<? extends IRelationship>, IRelationshipRenderer> map) {
        this.rendererMap = map;
    }
}

