/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IDragAndDropPolicy;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.IDragRowRenderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class DefaultDragRowRenderer
extends JPanel
implements IDragRowRenderer {
    private DragLayer dragLayer;
    private Object dragNode;
    private Object node;
    private TimelineObjectPath draggedTimelineObjectPath;
    private ITimeSpan timeSpan;
    private int userDropAction;

    public DefaultDragRowRenderer() {
        this.setOpaque(true);
        this.setBackground(Color.GRAY);
    }

    @Override
    public Component getDragRowRendererComponent(DragLayer layer, Object node, TimelineObjectPath draggedTimelineObjectPath, ITimeSpan span, int userDropAction) {
        this.dragLayer = layer;
        this.node = node;
        this.draggedTimelineObjectPath = draggedTimelineObjectPath;
        this.timeSpan = span;
        this.userDropAction = userDropAction;
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        switch (this.dragLayer.getEditMode()) {
            case CHANGE_NODE: 
            case CHANGE_NODE_AND_TIME_SPAN: {
                IPolicyProvider pp = this.dragLayer.getLayerPolicyProvider();
                IDragAndDropPolicy dnd = pp.getPolicy(IDragAndDropPolicy.class);
                int supportedDropActions = dnd.getDropActions(this.draggedTimelineObjectPath, this.dragLayer.getModel(), this.node, this.dragLayer.getModel(), this.timeSpan.getStartTime());
                if ((this.userDropAction & supportedDropActions) != 0) break;
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
                super.paintComponent(g2d);
                g2d.dispose();
                break;
            }
        }
    }

    protected DragLayer getDragLayer() {
        return this.dragLayer;
    }

    protected Object getNode() {
        return this.node;
    }

    protected Object getDragNode() {
        return this.dragNode;
    }

    protected TimelineObjectPath getDraggedTimelineObjectPath() {
        return this.draggedTimelineObjectPath;
    }

    protected ITimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    protected int getUserDropAction() {
        return this.userDropAction;
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

