/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class DatelineLayer
extends AbstractSystemLayer
implements PropertyChangeListener {
    private static TexturePaint texturePaint;
    private Paint focusedTimeSpanFillPaint = ColorUtil.getFocusBackground();
    private Paint focusedTimeSpanLinePaint = Color.BLACK;
    private boolean focusedTimeVisible = false;
    private boolean horizonLimitsVisible = false;

    public DatelineLayer(LayerContainer lc) {
        super("Dateline Layer", lc);
        this.setAlpha(0.3f);
        lc.getDateline().addPropertyChangeListener(this);
    }

    @Override
    protected void paintLayer(Graphics g) {
        ITimeSpan span;
        super.paintLayer(g);
        Graphics2D g2d = (Graphics2D)g;
        Dateline dateline = this.getDateline();
        if (this.isFocusedTimeVisible() && (span = dateline.getFocusedTimeSpan()) != null) {
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
            int x1 = dateline.getTimeLocation(span.getStartTime());
            int x2 = dateline.getTimeLocation(span.getEndTime());
            int h = this.layerContainer.getHeight();
            g2d.setPaint(this.getFocusedTimeSpanFillPaint());
            g2d.fillRect(x1, 0, x2 - x1, h);
            g2d.setComposite(comp);
            g2d.setPaint(this.getFocusedTimeSpanLinePaint());
            g2d.drawLine(x1, 0, x1, h);
            g2d.drawLine(x2, 0, x2, h);
        }
        if (this.isHorizonLimitsVisible()) {
            this.paintHorizonLimits(dateline.getTimeSpan(), g);
        }
    }

    protected void paintHorizonLimits(ITimeSpan horizon, Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Dateline dateline = this.getDateline();
        int x1 = dateline.getTimeLocation(horizon.getStartTime());
        int x2 = dateline.getTimeLocation(horizon.getEndTime());
        int w = this.layerContainer.getWidth();
        int h = this.layerContainer.getHeight();
        g2d.setPaint(texturePaint);
        g2d.fillRect(0, 0, x1, h);
        g2d.fillRect(x2, 0, w - x2, h);
        g2d.setPaint(this.layerContainer.getForeground());
        g2d.drawLine(x1, 0, x1, h);
        g2d.drawLine(x2, 0, x2, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isFocusedTimeVisible()) {
            Dateline dateline = this.getDateline();
            if (evt.getSource().equals(dateline) && evt.getPropertyName().equals("focusedTimeSpan")) {
                ITimeSpan oldSpan = (ITimeSpan)evt.getOldValue();
                ITimeSpan newSpan = (ITimeSpan)evt.getNewValue();
                ITimeSpan union = oldSpan;
                if (oldSpan != null && newSpan == null) {
                    union = oldSpan;
                } else if (oldSpan == null && newSpan != null) {
                    union = newSpan;
                } else if (oldSpan != null && newSpan != null) {
                    union = oldSpan.union(newSpan);
                } else {
                    return;
                }
                int x1 = dateline.getTimeLocation(union.getStartTime());
                int x2 = dateline.getTimeLocation(union.getEndTime());
                Rectangle rect = new Rectangle(x1, 0, x2 - x1, this.layerContainer.getHeight());
                rect.grow(5, 5);
                this.repaint(rect);
            }
        }
    }

    public Paint getFocusedTimeSpanFillPaint() {
        return this.focusedTimeSpanFillPaint;
    }

    public void setFocusedTimeSpanFillPaint(Paint fillPaint) {
        this.focusedTimeSpanFillPaint = fillPaint;
    }

    public Paint getFocusedTimeSpanLinePaint() {
        return this.focusedTimeSpanLinePaint;
    }

    public void setFocusedTimeSpanLinePaint(Paint color) {
        this.focusedTimeSpanLinePaint = color;
    }

    public boolean isFocusedTimeVisible() {
        return this.focusedTimeVisible;
    }

    public void setFocusedTimeVisible(boolean visible) {
        this.focusedTimeVisible = visible;
    }

    public boolean isHorizonLimitsVisible() {
        return this.horizonLimitsVisible;
    }

    public void setHorizonLimitsVisible(boolean visible) {
        this.horizonLimitsVisible = visible;
    }

    static {
        BufferedImage img = new BufferedImage(4, 2, 2);
        Graphics g = img.getGraphics();
        g.setColor(Color.GRAY);
        g.drawLine(0, 0, 0, 0);
        g.drawLine(2, 1, 2, 1);
        texturePaint = new TexturePaint(img, new Rectangle(0, 0, img.getWidth(), img.getHeight()));
    }
}

