/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.ICapacityObject;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IEditCapacityObjectPolicy;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.DefaultEditModeController;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.IEditModeController;
import java.awt.event.MouseEvent;

public class CapacityObjectEditModeController
extends DefaultEditModeController {
    @Override
    public IEditModeController.EditMode getEditMode(DragLayer layer, ObjectBounds bounds, MouseEvent evt) {
        Object timelineObject = bounds.getObject();
        if (timelineObject instanceof ICapacityObject) {
            LayerContainer layerContainer = layer.getLayerContainer();
            IPolicyProvider policyProvider = layerContainer.getPolicyProvider();
            IEditCapacityObjectPolicy cp = policyProvider.getPolicy(IEditCapacityObjectPolicy.class);
            IGanttChartModel model = bounds.getModel();
            if (cp.isCapacityChangeable(bounds.getPath(), model) && this.isChangeCapacityLocation(bounds, evt)) {
                return IEditModeController.EditMode.CHANGE_CAPACITY;
            }
        }
        return super.getEditMode(layer, bounds, evt);
    }

    protected boolean isChangeCapacityLocation(ObjectBounds bounds, MouseEvent evt) {
        if (!this.isUsingDragOverrideModifiers(evt)) {
            int y = evt.getPoint().y;
            return y > bounds.y && y < bounds.y + 5;
        }
        return false;
    }
}

