/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Logger;

public abstract class AbstractLayer {
    private static final Logger LOGGER = Logger.getLogger(AbstractLayer.class.getName());
    public static final String PROPERTY_ALPHA = "alpha";
    public static final String PROPERTY_VISIBLE = "visible";
    private String name;
    protected LayerContainer layerContainer;
    protected AbstractGanttChart ganttChart;
    protected float alpha = 1.0f;
    protected PropertyChangeSupport changeSupport;
    private boolean visible = true;

    protected AbstractLayer(String name, LayerContainer lc) {
        if (name == null) {
            throw new IllegalArgumentException("layer name can not be NULL");
        }
        if (lc == null) {
            throw new IllegalArgumentException("layer container can not be NULL");
        }
        this.name = name;
        this.changeSupport = new PropertyChangeSupport(this);
        this.layerContainer = lc;
        this.ganttChart = this.layerContainer.getGanttChart();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public void tearDown() {
        LOGGER.fine("tearing down layer " + this.getName());
    }

    public ITimeSpan getTimeSpanUsed() {
        return TimeSpan.UNDEFINED;
    }

    public String getName() {
        return this.name;
    }

    public LayerContainer getLayerContainer() {
        return this.layerContainer;
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    public TreeTable getTreeTable() {
        return this.layerContainer.getTreeTable();
    }

    public int getStartRow() {
        return this.layerContainer.getStartRow();
    }

    public IGanttChartModel getModel() {
        return this.layerContainer.getModel();
    }

    public Timeline getTimeline() {
        return this.layerContainer.getTimeline();
    }

    public Dateline getDateline() {
        return this.layerContainer.getDateline();
    }

    public Eventline getEventline() {
        return this.layerContainer.getEventline();
    }

    public IPolicyProvider getLayerPolicyProvider() {
        return this.layerContainer.getPolicyProvider();
    }

    public IPolicyProvider getTreeTablePolicyProvider() {
        return this.getTreeTable().getPolicyProvider();
    }

    public long getTimeAt(int x) {
        return this.getTimeline().getDateline().getTimeAt(x);
    }

    public int getTimeLocation(long time) {
        return this.getTimeline().getDateline().getTimeLocation(time);
    }

    protected void paintLayer(Graphics g) {
        SecurityManager sm = System.getSecurityManager();
        try {
            if (sm != null) {
                sm.checkPropertyAccess("com.dlsc.flexgantt.debug.layernames");
            }
            if (Boolean.getBoolean("com.dlsc.flexgantt.debug.layernames")) {
                if (this instanceof TimelineObjectLayer) {
                    g.setColor(Color.BLUE);
                } else if (this instanceof AbstractSystemLayer) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.GREEN);
                }
                int z = this.layerContainer.getLayerIndex(this);
                int height = g.getFontMetrics().getHeight();
                int width = 100;
                g.fillRect(0, z * height, width, height);
                g.setColor(Color.WHITE);
                g.drawRect(0, z * height, width, height);
                int ascent = g.getFontMetrics().getAscent();
                g.drawString("(" + z + ") " + this.name, 5, z * height + height / 2 + ascent / 2);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("transparency value must be within [0,1] interval");
        }
        float oldAlpha = this.alpha;
        this.alpha = alpha;
        this.changeSupport.firePropertyChange(PROPERTY_ALPHA, Float.valueOf(oldAlpha), Float.valueOf(alpha));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean old = this.visible;
        this.visible = visible;
        this.changeSupport.firePropertyChange(PROPERTY_VISIBLE, old, visible);
    }

    public String getToolTipText(MouseEvent e) {
        return null;
    }

    public void repaint() {
        this.layerContainer.repaint();
    }

    public void repaint(int x, int y, int width, int height) {
        this.layerContainer.repaint(x, y, width, height);
    }

    public void repaint(Rectangle r) {
        this.layerContainer.repaint(r);
    }

    public int getWidth() {
        return this.layerContainer.getWidth();
    }

    public int getHeight() {
        return this.layerContainer.getHeight();
    }
}

