/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.action.gantt;

import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.action.gantt.UndoAction;
import com.dlsc.flexgantt.util.Messages;
import java.text.MessageFormat;

public class UndoActionLabeled<T extends AbstractGanttChart>
extends UndoAction<T> {
    public UndoActionLabeled(T gc) {
        super(gc);
        this.setToolTipText(Messages.getString("UndoActionLabeled.TOOLTIP"));
        this.updateActionName();
    }

    private void updateActionName() {
        ICommand cmd = this.ganttChart.getCommandStack().getUndoableCommand();
        if (cmd != null) {
            String pattern = Messages.getString("UndoActionLabeled.NAME");
            this.putValue("Name", MessageFormat.format(pattern, cmd.getName()));
        }
        if (!this.isEnabled()) {
            this.putValue("Name", Messages.getString("UndoAction.NAME"));
        }
    }

    @Override
    public void commandStackChanged(CommandStackEvent event) {
        super.commandStackChanged(event);
        this.updateActionName();
    }
}

