/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.model.paging.IPagingModel;
import com.dlsc.flexgantt.model.paging.IPagingModelListener;
import com.dlsc.flexgantt.model.paging.PagingEvent;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GanttChartControl;
import com.dlsc.flexgantt.swing.PagingControl;
import com.dlsc.flexgantt.swing.PagingControlType;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.Selector;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.util.EnumMap;
import javax.swing.JComponent;

public class PagingControlPanel
extends GanttChartControl
implements IPagingModelListener {
    private EnumMap<PagingControlType, PagingControl> pageControlMap = new EnumMap(PagingControlType.class);
    private Selector pagingSelector;

    public PagingControlPanel(AbstractGanttChart gc) {
        super(gc);
        this.pageControlMap.put(PagingControlType.BEGINNING, new PagingControl(this, PagingControlType.BEGINNING));
        this.pageControlMap.put(PagingControlType.EARLIER, new PagingControl(this, PagingControlType.EARLIER));
        this.pageControlMap.put(PagingControlType.CUSTOM, new PagingControl(this, PagingControlType.CUSTOM));
        this.pageControlMap.put(PagingControlType.LATER, new PagingControl(this, PagingControlType.LATER));
        this.pageControlMap.put(PagingControlType.END, new PagingControl(this, PagingControlType.END));
        this.setLayout(new GridLayout(1, PagingControlType.values().length));
        this.setName("PagingControlPanel");
        this.add(this.pageControlMap.get((Object)PagingControlType.BEGINNING));
        this.add(this.pageControlMap.get((Object)PagingControlType.EARLIER));
        this.add(this.pageControlMap.get((Object)PagingControlType.CUSTOM));
        this.add(this.pageControlMap.get((Object)PagingControlType.LATER));
        this.add(this.pageControlMap.get((Object)PagingControlType.END));
        this.setBorder(null);
        gc.addPropertyChangeListener(this);
        IPagingModel pagingModel = gc.getPagingModel();
        if (pagingModel != null) {
            pagingModel.addPagingModelListener(this);
        }
        this.updateControls();
    }

    private void updateControls() {
        IPagingModel model = this.getGanttChart().getPagingModel();
        if (model != null) {
            this.pageControlMap.get((Object)PagingControlType.BEGINNING).setEnabled(true);
            this.pageControlMap.get((Object)PagingControlType.EARLIER).setEnabled(model.hasEarlierPage());
            this.pageControlMap.get((Object)PagingControlType.LATER).setEnabled(model.hasLaterPage());
            this.pageControlMap.get((Object)PagingControlType.END).setEnabled(true);
        } else {
            this.pageControlMap.get((Object)PagingControlType.BEGINNING).setEnabled(false);
            this.pageControlMap.get((Object)PagingControlType.EARLIER).setEnabled(false);
            this.pageControlMap.get((Object)PagingControlType.LATER).setEnabled(false);
            this.pageControlMap.get((Object)PagingControlType.END).setEnabled(false);
        }
    }

    @Override
    public boolean isVisible() {
        return this.getGanttChart().getPagingModel() != null;
    }

    public PagingControl getPagingControl(PagingControlType type) {
        return this.pageControlMap.get((Object)type);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource().equals(this.getGanttChart()) && evt.getPropertyName().equals("pagingModel")) {
            IPagingModel oldModel = (IPagingModel)evt.getOldValue();
            IPagingModel newModel = (IPagingModel)evt.getNewValue();
            if (oldModel != null) {
                oldModel.removePagingModelListener(this);
            }
            if (newModel != null) {
                newModel.addPagingModelListener(this);
            }
            this.updateControls();
        }
    }

    @Override
    public void pageWillChange(PagingEvent evt) {
    }

    @Override
    public void pageChanged(PagingEvent evt) {
        this.updateControls();
    }

    public void openPageSelection() {
        ISelectorFactory sf = this.getGanttChart().getSelectorFactory();
        if (this.pagingSelector == null) {
            this.pagingSelector = sf.createSelector(this.getGanttChart(), (JComponent)this.pageControlMap.get((Object)PagingControlType.CUSTOM), ISelectorFactory.SelectorID.PAGES);
        }
        this.pagingSelector.setVisible(!this.pagingSelector.isVisible());
    }
}

