/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IMultiGanttChartContainer;
import com.dlsc.flexgantt.swing.IMultiGanttChartContainerListener;
import com.dlsc.flexgantt.swing.MultiGanttChartContainerEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultiGanttChartContainer<T extends AbstractGanttChart>
extends JPanel
implements IMultiGanttChartContainer<T>,
ChangeListener {
    private JTabbedPane tabbedPane;

    public MultiGanttChartContainer() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Object gc = MultiGanttChartContainer.this.getSelectedGanttChart();
                if (gc != null) {
                    ((JComponent)gc).requestFocusInWindow();
                }
            }
        });
        this.add("Center", this.tabbedPane);
    }

    @Override
    public T getGanttChart(int index) {
        return (T)((AbstractGanttChart)this.tabbedPane.getComponent(index));
    }

    @Override
    public int getGanttChartCount() {
        return this.tabbedPane.getTabCount();
    }

    @Override
    public T getSelectedGanttChart() {
        return (T)((AbstractGanttChart)this.tabbedPane.getSelectedComponent());
    }

    public void addGanttChart(String title, T gc) {
        this.addGanttChart(title, null, gc, null);
    }

    public void addGanttChart(String title, Icon icon, T gc) {
        this.addGanttChart(title, icon, gc, null);
    }

    public void addGanttChart(String title, Icon icon, T gc, String tip) {
        this.tabbedPane.addTab(title, icon, (Component)gc, tip);
        MultiGanttChartContainerEvent evt = new MultiGanttChartContainerEvent(this, MultiGanttChartContainerEvent.ID.GANTT_CHART_ADDED, (AbstractGanttChart)gc);
        this.fireContainerChanged(evt);
    }

    public void setSelectedGanttChart(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    public void setSelectedGanttChart(T gc) {
        this.tabbedPane.setSelectedComponent((Component)gc);
        ((JComponent)gc).requestFocusInWindow();
    }

    @Override
    public int getGanttChartIndex(T gc) {
        return this.tabbedPane.indexOfComponent((Component)gc);
    }

    public void insertGanttChart(String title, T gc, int index) {
        this.insertGanttChart(title, null, gc, null, index);
    }

    public void insertGanttChart(String title, Icon icon, T gc, int index) {
        this.insertGanttChart(title, icon, gc, null, index);
    }

    public void insertGanttChart(String title, Icon icon, T gc, String tip, int index) {
        this.tabbedPane.insertTab(title, icon, (Component)gc, tip, index);
        MultiGanttChartContainerEvent evt = new MultiGanttChartContainerEvent(this, MultiGanttChartContainerEvent.ID.GANTT_CHART_INSERTED, (AbstractGanttChart)gc);
        this.fireContainerChanged(evt);
    }

    public void removeGanttChart(T gc) {
        this.tabbedPane.remove((Component)gc);
        MultiGanttChartContainerEvent evt = new MultiGanttChartContainerEvent(this, MultiGanttChartContainerEvent.ID.GANTT_CHART_REMOVED, (AbstractGanttChart)gc);
        this.fireContainerChanged(evt);
    }

    public void removeGanttChart(int index) {
        T gc = this.getGanttChart(index);
        this.removeGanttChart(gc);
    }

    public void removeAllGanttCharts() {
        int count;
        for (int i = count = this.getGanttChartCount(); i >= 0; --i) {
            this.removeGanttChart(i);
        }
    }

    @Override
    public void addMultiGanttChartContainerListener(IMultiGanttChartContainerListener l) {
        this.listenerList.add(IMultiGanttChartContainerListener.class, l);
    }

    @Override
    public void removeMultiGanttChartContainerListener(IMultiGanttChartContainerListener l) {
        this.listenerList.remove(IMultiGanttChartContainerListener.class, l);
    }

    protected void fireContainerChanged(MultiGanttChartContainerEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IMultiGanttChartContainerListener.class) continue;
            ((IMultiGanttChartContainerListener)listeners[i + 1]).containerChanged(evt);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        T gc = this.getSelectedGanttChart();
        ((JComponent)gc).requestFocusInWindow();
        MultiGanttChartContainerEvent evt = new MultiGanttChartContainerEvent(this, MultiGanttChartContainerEvent.ID.GANTT_CHART_CHANGED, (AbstractGanttChart)gc);
        this.fireContainerChanged(evt);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }
}

