/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.MessageTableModel;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class MessageTable
extends JTable {
    private AbstractGanttChart ganttChart;

    public MessageTable(AbstractGanttChart gc, MessageTableModel tableModel) {
        if (gc == null) {
            throw new IllegalArgumentException("gantt chart can not be NULL");
        }
        this.ganttChart = gc;
        this.setModel(tableModel);
        TableColumn iconColumn = this.getColumnModel().getColumn(0);
        TableColumn textColumn = this.getColumnModel().getColumn(1);
        TableColumn timeColumn = this.getColumnModel().getColumn(2);
        iconColumn.setMaxWidth(20);
        iconColumn.setMinWidth(20);
        textColumn.setPreferredWidth(500);
        timeColumn.setPreferredWidth(300);
        iconColumn.setHeaderValue(" ");
        textColumn.setHeaderValue(Messages.getString("MessageTable.HEADER_MESSAGE"));
        timeColumn.setHeaderValue(Messages.getString("MessageTable.HEADER_TIME"));
        iconColumn.setCellRenderer(new IconCellRenderer());
        final MessageTableModel fModel = tableModel;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                IMessage msg;
                if (e.getClickCount() == 2 && (msg = fModel.getMessageInRow(row = MessageTable.this.rowAtPoint(e.getPoint()))) != null) {
                    MessageTable.this.ganttChart.showMessageContext(msg);
                }
            }
        });
        this.setRowHeight(IconRegistry.getIconDimension().height + 2);
        int width = IconRegistry.getIconDimension().width + 4;
        iconColumn.setWidth(width);
        iconColumn.setMaxWidth(width);
        iconColumn.setMinWidth(width);
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    class IconCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public IconCellRenderer() {
            this.setText("");
            this.setIcon(null);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setIcon((Icon)value);
            return this;
        }
    }
}

