/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GridControl;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.IGridComponentListener;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class GridControlPanel
extends JPanel
implements IGridComponentListener {
    private Map<IGridComponent, GridControl> controlMap;
    private AbstractGanttChart ganttChart;

    public GridControlPanel(AbstractGanttChart gc) {
        if (gc == null) {
            throw new IllegalArgumentException("Gantt chart can not be NULL");
        }
        this.ganttChart = gc;
        for (IGridComponent comp : gc.getGridComponents()) {
            comp.addGridComponentListener(this);
        }
        this.updatePanel();
    }

    private void updatePanel() {
        this.removeAll();
        if (this.controlMap != null) {
            for (GridControl control : this.controlMap.values()) {
                control.tearDown();
            }
        }
        int visible = 0;
        for (IGridComponent comp : this.ganttChart.getGridComponents()) {
            if (!comp.isGridControlVisible()) continue;
            ++visible;
        }
        this.controlMap = new HashMap<IGridComponent, GridControl>();
        this.setLayout(new GridLayout(1, visible, 0, 0));
        for (IGridComponent comp : this.ganttChart.getGridComponents()) {
            if (!comp.isGridControlVisible()) continue;
            GridControl control = new GridControl(this.ganttChart, comp);
            this.controlMap.put(comp, control);
            this.add(control);
        }
    }

    public GridControl getGridControl(IGridComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("grid component can not be NULL");
        }
        if (!this.controlMap.containsKey(comp)) {
            throw new IllegalArgumentException("no grid control exists for the given grid component (must be a member of another Gantt chart)");
        }
        return this.controlMap.get(comp);
    }

    @Override
    public void gridComponentChanged() {
        this.updatePanel();
    }
}

