/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.ICommandStack;
import com.dlsc.flexgantt.command.ICommandStackListener;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.ISortingListener;
import com.dlsc.flexgantt.swing.SortingEvent;
import com.dlsc.flexgantt.swing.util.InfiniteProgressPanel;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

public class GanttChartGlassPane
extends InfiniteProgressPanel
implements ICommandStackListener,
PropertyChangeListener,
ISortingListener,
IProgressMonitor {
    private ICommandStack stack;
    private boolean block;
    private boolean canceled;

    public GanttChartGlassPane(AbstractGanttChart gc) {
        this.setName("GanttChartGlassPane");
        this.setCommandStack(gc.getCommandStack());
        gc.addPropertyChangeListener(this);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setOpaque(false);
        this.enableEvents(131128L);
        gc.addSortingListener(this);
    }

    private void setCommandStack(ICommandStack stack) {
        if (this.stack != null) {
            this.stack.removeCommandStackListener(this);
        }
        this.stack = stack;
        this.stack.addCommandStackListener(this);
    }

    public void block() {
        this.setVisible(true);
        this.block = true;
    }

    public void unblock() {
        this.setVisible(false);
        this.stop();
        this.block = false;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (!this.block) {
            super.processEvent(e);
        }
    }

    @Override
    public void commandStackChanged(CommandStackEvent evt) {
        final CommandStackEvent fe = evt;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (fe.getId()) {
                    case COMMAND_STARTED: {
                        GanttChartGlassPane.this.block();
                        break;
                    }
                    case COMMAND_EXECUTED: 
                    case COMMAND_UNDONE: 
                    case COMMAND_FAILED: 
                    case COMMAND_CANCELED: {
                        GanttChartGlassPane.this.unblock();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown command event id: " + (Object)((Object)fe.getId()));
                    }
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("commandStack")) {
            this.setCommandStack((ICommandStack)evt.getNewValue());
        }
    }

    @Override
    public void sorting(SortingEvent evt) {
        switch (evt.getId()) {
            case SORTING_STARTED: {
                this.block();
                break;
            }
            case SORTING_FINISHED: {
                this.unblock();
            }
        }
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.setText(name);
        this.start();
    }

    @Override
    public void done() {
        this.stop();
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setCanceled(boolean value) {
        this.canceled = value;
        this.interrupt();
    }

    @Override
    public void setTaskName(String name) {
        this.setText(name);
    }

    @Override
    public void subTask(String name) {
        this.setText(name);
    }

    @Override
    public void worked(int work) {
    }
}

