/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IGanttChartActionMap;
import com.dlsc.flexgantt.swing.action.dateline.ZoomInAction;
import com.dlsc.flexgantt.swing.action.dateline.ZoomOutAction;
import com.dlsc.flexgantt.swing.action.gantt.AddHighlightedTimelineObjectsAction;
import com.dlsc.flexgantt.swing.action.gantt.ClearHighlightedTimelineObjectsAction;
import com.dlsc.flexgantt.swing.action.gantt.CrosshairAction;
import com.dlsc.flexgantt.swing.action.gantt.DeleteNodeAction;
import com.dlsc.flexgantt.swing.action.gantt.DeleteTimelineObjectAction;
import com.dlsc.flexgantt.swing.action.gantt.GridAction;
import com.dlsc.flexgantt.swing.action.gantt.IndentNodeAction;
import com.dlsc.flexgantt.swing.action.gantt.InsertNodeAction;
import com.dlsc.flexgantt.swing.action.gantt.MoveFocusAction;
import com.dlsc.flexgantt.swing.action.gantt.OutdentNodeAction;
import com.dlsc.flexgantt.swing.action.gantt.RedoAction;
import com.dlsc.flexgantt.swing.action.gantt.RemoveHighlightedTimelineObjectsAction;
import com.dlsc.flexgantt.swing.action.gantt.SelectRowsAction;
import com.dlsc.flexgantt.swing.action.gantt.ToggleNodeAction;
import com.dlsc.flexgantt.swing.action.gantt.UndoAction;
import com.dlsc.flexgantt.swing.action.timeline.EventlineAction;
import com.dlsc.flexgantt.swing.action.timeline.ScrollTimelineAction;
import com.dlsc.flexgantt.util.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;

public abstract class AbstractGanttChartActionMap<T extends AbstractGanttChart>
extends ActionMap
implements IGanttChartActionMap {
    public static final String GRID_ACTION = "grid_action";
    public static final String ZOOM_IN_ACTION = "zoom_in_action";
    public static final String ZOOM_OUT_ACTION = "zoom_out_action";
    public static final String TOGGLE_CROSSHAIR_ACTION = "crosshair_action";
    public static final String TOGGLE_EVENTLINE_ACTION = "eventline_action";
    public static final String ADD_HIGHLIGHTED_OBJECTS_ACTION = "add_highlight_action";
    public static final String REMOVE_HIGHLIGHTED_OBJECTS_ACTION = "remove_highlight_action";
    public static final String CLEAR_HIGHLIGHTED_OBJECTS_ACTION = "clear_highlight_action";
    public static final String DELETE_TIMELINE_OBJECTS_ACTION = "delete_timeline_objects_action";
    public static final String DELETE_NODE_ACTION = "delete_node_action";
    public static final String SELECT_ROWS_DOWNWARD_ACTION = "select_rows_downward_action";
    public static final String SELECT_ROWS_UPWARD_ACTION = "select_rows_upward_action";
    public static final String INDENT_NODES_ACTION = "indent_nodes_action";
    public static final String INSERT_NODE_ACTION = "insert_node_action";
    public static final String OUTDENT_NODES_ACTION = "outdent_nodes_action";
    public static final String UNDO_ACTION = "undo_action";
    public static final String REDO_ACTION = "redo_action";
    public static final String MOVE_FOCUS_PREVIOUS_ACTION = "move_previous_action";
    public static final String MOVE_FOCUS_NEXT_ACTION = "move_next_action";
    public static final String MOVE_FOCUS_ABOVE_ACTION = "move_up_action";
    public static final String MOVE_FOCUS_BELOW_ACTION = "move_down_action";
    public static final String MOVE_FOCUS_HOME_ACTION = "move_home_action";
    public static final String MOVE_FOCUS_BOTTOM_ACTION = "move_bottom_action";
    public static final String MOVE_FOCUS_PAGE_UP_ACTION = "move_page_up_action";
    public static final String MOVE_FOCUS_PAGE_DOWN_ACTION = "move_page_down_action";
    public static final String TOGGLE_NODE_ACTION = "toggle_node_action";
    public static final String SCROLL_TIMELINE_LEFT_ACTION = "scroll_left_action";
    public static final String SCROLL_TIMELINE_RIGHT_ACTION = "scroll_right_action";
    public static final String SCROLL_TIMELINE_LEFT_FAST_ACTION = "scroll_left_fast_action";
    public static final String SCROLL_TIMELINE_RIGHT_FAST_ACTION = "scroll_right_fast_action";
    private List<String> categories = new LinkedList<String>();
    public static final String CATEGORY_TABLE = Messages.getString("AbstractGanttChartActionMap.CATEGORY_NAME_TABLE");
    public static final String CATEGORY_TIMELINE = Messages.getString("AbstractGanttChartActionMap.CATEGORY_NAME_TIMELINE");
    public static final String CATEGORY_CHART = Messages.getString("AbstractGanttChartActionMap.CATEGORY_NAME_CHART");
    public static final String CATEGORY_OTHER = Messages.getString("AbstractGanttChartActionMap.CATEGORY_NAME_OTHER");
    private Map<String, List<String>> categoryActionMap = new HashMap<String, List<String>>();

    private AbstractGanttChartActionMap() {
        this.addCategory(CATEGORY_TIMELINE);
        this.addCategory(CATEGORY_TABLE);
        this.addCategory(CATEGORY_CHART);
        this.addCategory(CATEGORY_OTHER);
        this.initCategoryActionMap();
    }

    public AbstractGanttChartActionMap(T gc) {
        this();
        this.put(GRID_ACTION, new GridAction<T>(gc));
        this.put(ZOOM_IN_ACTION, new ZoomInAction(((AbstractGanttChart)gc).getDateline()));
        this.put(ZOOM_OUT_ACTION, new ZoomOutAction(((AbstractGanttChart)gc).getDateline()));
        this.put(TOGGLE_CROSSHAIR_ACTION, new CrosshairAction<T>(gc));
        this.put(TOGGLE_EVENTLINE_ACTION, new EventlineAction(((AbstractGanttChart)gc).getTimeline()));
        this.put(UNDO_ACTION, new UndoAction<T>(gc));
        this.put(REDO_ACTION, new RedoAction<T>(gc));
        this.put(ADD_HIGHLIGHTED_OBJECTS_ACTION, new AddHighlightedTimelineObjectsAction<T>(gc));
        this.put(REMOVE_HIGHLIGHTED_OBJECTS_ACTION, new RemoveHighlightedTimelineObjectsAction<T>(gc));
        this.put(CLEAR_HIGHLIGHTED_OBJECTS_ACTION, new ClearHighlightedTimelineObjectsAction<T>(gc));
        this.put(DELETE_TIMELINE_OBJECTS_ACTION, new DeleteTimelineObjectAction<T>(gc));
        this.put(INDENT_NODES_ACTION, new IndentNodeAction<T>(gc));
        this.put(OUTDENT_NODES_ACTION, new OutdentNodeAction<T>(gc));
        this.put(INSERT_NODE_ACTION, new InsertNodeAction<T>(gc));
        this.put(MOVE_FOCUS_ABOVE_ACTION, new MoveFocusAction<T>(gc, MoveFocusAction.Direction.ABOVE));
        this.put(MOVE_FOCUS_BELOW_ACTION, new MoveFocusAction<T>(gc, MoveFocusAction.Direction.BELOW));
        this.put(MOVE_FOCUS_PREVIOUS_ACTION, new MoveFocusAction<T>(gc, MoveFocusAction.Direction.PREVIOUS));
        this.put(MOVE_FOCUS_NEXT_ACTION, new MoveFocusAction<T>(gc, MoveFocusAction.Direction.NEXT));
        this.put(MOVE_FOCUS_HOME_ACTION, new MoveFocusAction<T>(gc, MoveFocusAction.Direction.HOME));
        this.put(MOVE_FOCUS_BOTTOM_ACTION, new MoveFocusAction<T>(gc, MoveFocusAction.Direction.BOTTOM));
        this.put(MOVE_FOCUS_PAGE_UP_ACTION, new MoveFocusAction<T>(gc, MoveFocusAction.Direction.PAGE_UP));
        this.put(MOVE_FOCUS_PAGE_DOWN_ACTION, new MoveFocusAction<T>(gc, MoveFocusAction.Direction.PAGE_DOWN));
        this.put(TOGGLE_NODE_ACTION, new ToggleNodeAction<T>(gc));
        this.put(SCROLL_TIMELINE_LEFT_ACTION, new ScrollTimelineAction(((AbstractGanttChart)gc).getTimeline(), ScrollTimelineAction.ScrollDirection.LEFT, false));
        this.put(SCROLL_TIMELINE_RIGHT_ACTION, new ScrollTimelineAction(((AbstractGanttChart)gc).getTimeline(), ScrollTimelineAction.ScrollDirection.RIGHT, false));
        this.put(SCROLL_TIMELINE_LEFT_FAST_ACTION, new ScrollTimelineAction(((AbstractGanttChart)gc).getTimeline(), ScrollTimelineAction.ScrollDirection.LEFT, true));
        this.put(SCROLL_TIMELINE_RIGHT_FAST_ACTION, new ScrollTimelineAction(((AbstractGanttChart)gc).getTimeline(), ScrollTimelineAction.ScrollDirection.RIGHT, true));
        this.put(SELECT_ROWS_DOWNWARD_ACTION, new SelectRowsAction<T>(gc, true));
        this.put(SELECT_ROWS_UPWARD_ACTION, new SelectRowsAction<T>(gc, false));
        this.put(DELETE_NODE_ACTION, new DeleteNodeAction<T>(gc));
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void removeCategory(String category) {
        this.categories.remove(category);
    }

    public void addCategoryAction(String category, String actionID) {
        List<String> actions = this.categoryActionMap.get(category);
        if (actions == null) {
            actions = new ArrayList<String>();
            this.categoryActionMap.put(category, actions);
        }
        actions.add(actionID);
    }

    public void removeCategoryAction(String category, String actionID) {
        List<String> actions = this.categoryActionMap.get(category);
        if (actions != null) {
            actions.remove(actionID);
        }
    }

    @Override
    public Iterator<String> getCategories() {
        return this.categories.iterator();
    }

    @Override
    public Iterator<String> getCategoryActions(String category) {
        if (category == null) {
            throw new IllegalArgumentException("category can not be NULL");
        }
        if (!this.categories.contains(category)) {
            throw new IllegalArgumentException("unknown category: " + category);
        }
        return this.categoryActionMap.get(category).iterator();
    }

    protected void initCategoryActionMap() {
        this.addCategoryAction(CATEGORY_CHART, ADD_HIGHLIGHTED_OBJECTS_ACTION);
        this.addCategoryAction(CATEGORY_CHART, REMOVE_HIGHLIGHTED_OBJECTS_ACTION);
        this.addCategoryAction(CATEGORY_CHART, CLEAR_HIGHLIGHTED_OBJECTS_ACTION);
        this.addCategoryAction(CATEGORY_CHART, DELETE_TIMELINE_OBJECTS_ACTION);
        this.addCategoryAction(CATEGORY_CHART, TOGGLE_CROSSHAIR_ACTION);
        this.addCategoryAction(CATEGORY_CHART, GRID_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, MOVE_FOCUS_ABOVE_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, MOVE_FOCUS_BELOW_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, MOVE_FOCUS_PREVIOUS_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, MOVE_FOCUS_NEXT_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, MOVE_FOCUS_HOME_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, MOVE_FOCUS_BOTTOM_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, MOVE_FOCUS_PAGE_UP_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, MOVE_FOCUS_PAGE_DOWN_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, INSERT_NODE_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, INDENT_NODES_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, OUTDENT_NODES_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, TOGGLE_NODE_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, DELETE_NODE_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, SELECT_ROWS_DOWNWARD_ACTION);
        this.addCategoryAction(CATEGORY_TABLE, SELECT_ROWS_UPWARD_ACTION);
        this.addCategoryAction(CATEGORY_TIMELINE, ZOOM_IN_ACTION);
        this.addCategoryAction(CATEGORY_TIMELINE, ZOOM_OUT_ACTION);
        this.addCategoryAction(CATEGORY_TIMELINE, SCROLL_TIMELINE_LEFT_ACTION);
        this.addCategoryAction(CATEGORY_TIMELINE, SCROLL_TIMELINE_LEFT_FAST_ACTION);
        this.addCategoryAction(CATEGORY_TIMELINE, SCROLL_TIMELINE_RIGHT_ACTION);
        this.addCategoryAction(CATEGORY_TIMELINE, SCROLL_TIMELINE_RIGHT_FAST_ACTION);
        this.addCategoryAction(CATEGORY_TIMELINE, TOGGLE_EVENTLINE_ACTION);
        this.addCategoryAction(CATEGORY_OTHER, UNDO_ACTION);
        this.addCategoryAction(CATEGORY_OTHER, REDO_ACTION);
    }
}

