/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.AbstractPolicy;
import com.dlsc.flexgantt.policy.layer.IDragInfoPolicy;
import com.dlsc.flexgantt.util.Messages;
import java.text.NumberFormat;

public class DefaultDragInfoPolicy
extends AbstractPolicy
implements IDragInfoPolicy {
    private NumberFormat percentageFormatter = NumberFormat.getPercentInstance();
    private NumberFormat capacityFormatter = NumberFormat.getPercentInstance();

    @Override
    public Object getDragInfo(TimelineObjectPath path, IGanttChartModel model, IDatelineModel<?> datelineModel, Object dropNode, ITimeSpan dropSpan) {
        StringBuilder sb = new StringBuilder();
        if (model.getTimeSpan(path.getTimelineObject()).isEvent()) {
            sb.append(dropSpan.getStartTime());
        } else {
            sb.append(Messages.getString("DefaultDragInfoPolicy.START_TIME"));
            sb.append(dropSpan.getStartTime());
            sb.append("\n");
            sb.append(Messages.getString("DefaultDragInfoPolicy.END_TIME"));
            sb.append(dropSpan.getEndTime());
        }
        return sb.toString();
    }

    @Override
    public Object getDragInfo(TimelineObjectPath path, IGanttChartModel model, long timePoint, double percentageComplete) {
        return this.percentageFormatter.format(percentageComplete / 100.0);
    }

    @Override
    public Object getDragInfo(TimelineObjectPath path, IGanttChartModel model, int rowHeight, int y, double capacityUsed) {
        return this.capacityFormatter.format(capacityUsed / 100.0);
    }

    public NumberFormat getPercentageFormatter() {
        return this.percentageFormatter;
    }

    public void setPercentageFormatter(NumberFormat formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("formatter can not be NULL");
        }
        this.percentageFormatter = formatter;
    }

    public NumberFormat getCapacityFormatter() {
        return this.capacityFormatter;
    }

    public void setCapacityFormatter(NumberFormat formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("formatter can not be NULL");
        }
        this.capacityFormatter = formatter;
    }
}

