/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.AbstractPropertiesOwner;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.util.LabelType;
import com.dlsc.flexgantt.util.LabelTypeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultTimelineObject<T>
extends AbstractPropertiesOwner
implements ITimelineObject {
    private LabelTypeSupport labelSupport;
    private Object popupObject;
    private Object extendedPopupObject;
    private Object popupTitleObject;
    private ITimeSpan timeSpan = TimeSpan.UNDEFINED;
    private boolean selectable = true;
    private int dragActions = 3;
    private boolean durationChangeable = true;
    private boolean inPlaceEditable = true;
    private boolean deletable = true;
    private T userObject;
    private boolean startTimeChangeable = true;
    private int lineIndex = -1;
    private Object status;
    private List<ITimelineObject> children;

    public DefaultTimelineObject(String name, ITimeSpan timeSpan) {
        if (timeSpan == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        this.labelSupport = new LabelTypeSupport();
        this.timeSpan = timeSpan;
        this.popupTitleObject = name;
        this.setLabel(name, LabelType.NAME);
    }

    public DefaultTimelineObject(String name) {
        this(name, TimeSpan.UNDEFINED);
    }

    public DefaultTimelineObject(ITimeSpan timeSpan) {
        this("Untitled", timeSpan);
    }

    public DefaultTimelineObject() {
        this("Untitled", TimeSpan.UNDEFINED);
    }

    public void setUserObject(T obj) {
        this.userObject = obj;
    }

    public T getUserObject() {
        return this.userObject;
    }

    @Override
    public ITimeSpan getTimeSpan() {
        if (this.isParent()) {
            ITimeSpan span = TimeSpan.UNDEFINED;
            for (ITimelineObject child : this.children) {
                span = span.union(child.getTimeSpan());
            }
            return span;
        }
        return this.timeSpan;
    }

    @Override
    public void setTimeSpan(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        this.timeSpan = span;
    }

    @Override
    public int compareTo(ITimelineObject tlo) {
        return this.timeSpan.compareTo(tlo.getTimeSpan());
    }

    public void setLabel(String label, LabelType type) {
        this.labelSupport.setLabel(label, type);
    }

    @Override
    public String getLabel(LabelType type) {
        return this.labelSupport.getLabel(type);
    }

    @Override
    public boolean isStartTimeChangeable() {
        return this.startTimeChangeable;
    }

    public void setStartTimeChangeable(boolean changeable) {
        this.startTimeChangeable = changeable;
    }

    @Override
    public boolean isDurationChangeable() {
        return this.durationChangeable;
    }

    public void setDurationChangeable(boolean changeable) {
        this.durationChangeable = changeable;
    }

    @Override
    public Object getPopupObject(boolean extended) {
        if (extended) {
            return this.extendedPopupObject;
        }
        return this.popupObject;
    }

    public void setPopupObject(Object object, boolean extended) {
        if (extended) {
            this.extendedPopupObject = object;
        } else {
            this.popupObject = object;
        }
    }

    @Override
    public Object getPopupTitleObject() {
        return this.popupTitleObject;
    }

    public void setPopupTitleObject(Object object) {
        this.popupTitleObject = object;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean b) {
        this.selectable = b;
    }

    @Override
    public boolean isInPlaceEditable() {
        return this.inPlaceEditable;
    }

    public void setInPlaceEditable(boolean editable) {
        this.inPlaceEditable = editable;
    }

    public void setLineIndex(int index) {
        if (this.lineIndex < -1) {
            throw new IllegalArgumentException("line index must be larger than or equal to -1");
        }
        this.lineIndex = index;
    }

    @Override
    public int getLineIndex() {
        return this.lineIndex;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    @Override
    public boolean isDeletable() {
        return this.deletable;
    }

    @Override
    public Object getStatus() {
        return this.status;
    }

    public void setStatus(Object status) {
        this.status = status;
    }

    public String toString() {
        return this.getLabel(LabelType.NAME);
    }

    public void addChild(ITimelineObject child) {
        if (child == null) {
            throw new IllegalArgumentException("timeline object can not be NULL");
        }
        if (this.children == null) {
            this.children = new ArrayList<ITimelineObject>();
        }
        this.children.add(child);
    }

    public void removeChild(ITimelineObject child) {
        if (child == null) {
            throw new IllegalArgumentException("timeline object can not be NULL");
        }
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public void setChildren(ITimelineObject ... children) {
        if (children == null) {
            throw new IllegalArgumentException("timeline objects can not be NULL");
        }
        this.setChildren(Arrays.asList(children));
    }

    public void setChildren(Collection<ITimelineObject> children) {
        if (children == null) {
            throw new IllegalArgumentException("timeline objects can not be NULL");
        }
        for (ITimelineObject tlo : children) {
            this.addChild(tlo);
        }
    }

    @Override
    public boolean isParent() {
        return this.children != null && this.children.size() > 0;
    }

    public Iterator<ITimelineObject> getChildren() {
        if (this.children != null) {
            return this.children.iterator();
        }
        List empty = Collections.emptyList();
        return empty.iterator();
    }

    public void setDragActions(int actions) {
        this.dragActions = actions;
    }

    @Override
    public int getDragActions() {
        return this.dragActions;
    }
}

