/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.dateline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.dateline.MarkerType;
import com.dlsc.flexgantt.util.Messages;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum TimeGranularity implements IGranularity<TimeGranularity>
{
    MILLISECOND(1L, Messages.getString("TimeGranularity.MILLISECONDS"), Messages.getString("TimeGranularity.MILLISECONDS_SINGULAR")),
    TEN_MILLISECONDS(10L, Messages.getString("TimeGranularity.MILLISECONDS_10"), Messages.getString("TimeGranularity.MILLISECONDS_10_SINGULAR")),
    HUNDRED_MILLISECONDS(100L, Messages.getString("TimeGranularity.MILLISECONDS_100"), Messages.getString("TimeGranularity.MILLISECONDS_100_SINGULAR")),
    SECOND(1000L, Messages.getString("TimeGranularity.SECONDS"), Messages.getString("TimeGranularity.SECONDS_SINGULAR")),
    FIVE_SECONDS(5000L, Messages.getString("TimeGranularity.SECONDS_5"), Messages.getString("TimeGranularity.SECONDS_5_SINGULAR")),
    TEN_SECONDS(10000L, Messages.getString("TimeGranularity.SECONDS_10"), Messages.getString("TimeGranularity.SECONDS_10_SINGULAR")),
    FIFTEEN_SECONDS(15000L, Messages.getString("TimeGranularity.SECONDS_15"), Messages.getString("TimeGranularity.SECONDS_15_SINGULAR")),
    THIRTY_SECONDS(30000L, Messages.getString("TimeGranularity.SECONDS_30"), Messages.getString("TimeGranularity.SECONDS_30_SINGULAR")),
    MINUTE(60000L, Messages.getString("TimeGranularity.MINUTES"), Messages.getString("TimeGranularity.MINUTES_SINGULAR")),
    FIVE_MINUTES(300000L, Messages.getString("TimeGranularity.MINUTES_5"), Messages.getString("TimeGranularity.MINUTES_5_SINGULAR")),
    TEN_MINUTES(600000L, Messages.getString("TimeGranularity.MINUTES_10"), Messages.getString("TimeGranularity.MINUTES_10_SINGULAR")),
    FIFTEEN_MINUTES(900000L, Messages.getString("TimeGranularity.MINUTES_15"), Messages.getString("TimeGranularity.MINUTES_15_SINGULAR")),
    THIRTY_MINUTES(1800000L, Messages.getString("TimeGranularity.MINUTES_30"), Messages.getString("TimeGranularity.MINUTES_30_SINGULAR")),
    HOUR(3600000L, Messages.getString("TimeGranularity.HOURS"), Messages.getString("TimeGranularity.HOURS_SINGULAR")),
    THREE_HOURS(10800000L, Messages.getString("TimeGranularity.HOURS_3"), Messages.getString("TimeGranularity.HOURS_3_SINGULAR")),
    SIX_HOURS(21600000L, Messages.getString("TimeGranularity.HOURS_6"), Messages.getString("TimeGranularity.HOURS_6_SINGULAR")),
    DAY_SHORT(86400000L, Messages.getString("TimeGranularity.DAYS"), Messages.getString("TimeGranularity.DAYS_SINGULAR")),
    DAY_TINY(86400000L, Messages.getString("TimeGranularity.DAYS_TINY"), Messages.getString("TimeGranularity.DAYS_TINY_SINGULAR")),
    WEEK(604800000L, Messages.getString("TimeGranularity.WEEKS"), Messages.getString("TimeGranularity.WEEKS_SINGULAR")),
    MONTH_SHORT(2592000000L, Messages.getString("TimeGranularity.MONTHS"), Messages.getString("TimeGranularity.MONTHS_SINGULAR")),
    MONTH_TINY(2592000000L, Messages.getString("TimeGranularity.MONTHS_TINY"), Messages.getString("TimeGranularity.MONTHS_TINY_SINGULAR")),
    QUARTER_YEAR(7776000000L, Messages.getString("TimeGranularity.MONTHS_3"), Messages.getString("TimeGranularity.MONTHS_3_SINGULAR")),
    HALF_YEAR(15552000000L, Messages.getString("TimeGranularity.MONTHS_6"), Messages.getString("TimeGranularity.MONTHS_6_SINGULAR")),
    YEAR(31536000000L, Messages.getString("TimeGranularity.YEARS"), Messages.getString("TimeGranularity.YEARS_SINGULAR")),
    DECADE(315360000000L, Messages.getString("TimeGranularity.DECADES"), Messages.getString("TimeGranularity.DECADES_SINGULAR")),
    CENTURY(3153600000000L, Messages.getString("TimeGranularity.CENTURIES"), Messages.getString("TimeGranularity.CENTURIES_SINGULAR")),
    MILLENIUM(31536000000000L, Messages.getString("TimeGranularity.MILLENIUMS"), Messages.getString("TimeGranularity.MILLENIUMS_SINGULAR"));

    private static final Logger LOGGER;
    private String name;
    private String singularName;
    private long milliseconds;
    private static int firstDayOfWeek;

    private TimeGranularity(long millis, String name, String singularName) {
        if (name == null) {
            throw new IllegalArgumentException("name of time granularity can not be NULL");
        }
        this.milliseconds = millis;
        this.name = name;
        this.singularName = singularName;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    @Override
    public long getStandardDuration() {
        return this.getMilliseconds();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long adjustTime(long time, TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("timezone can not be NULL");
        }
        Date date = new Date(time);
        this.adjustDate(date, timeZone);
        return date.getTime();
    }

    public void adjustDate(Date date, TimeZone timeZone) {
        if (date == null) {
            throw new IllegalArgumentException("date can not be NULL");
        }
        if (timeZone == null) {
            throw new IllegalArgumentException("timezone can not be NULL");
        }
        Calendar c = Calendar.getInstance(timeZone);
        c.setTime(date);
        this.adjustCalendar(c);
        date.setTime(c.getTimeInMillis());
    }

    public void adjustCalendar(Calendar c) {
        if (c == null) {
            throw new IllegalArgumentException("the calendar object can not be NULL");
        }
        LOGGER.fine("original calendar: " + c.getTime());
        switch (this) {
            case MILLISECOND: {
                break;
            }
            case TEN_MILLISECONDS: {
                TimeGranularity.round(c, 14, 10);
                break;
            }
            case HUNDRED_MILLISECONDS: {
                TimeGranularity.round(c, 14, 100);
                break;
            }
            case SECOND: {
                c.set(14, c.getActualMinimum(14));
                break;
            }
            case FIVE_SECONDS: {
                c.set(14, c.getActualMinimum(14));
                TimeGranularity.round(c, 13, 5);
                break;
            }
            case TEN_SECONDS: {
                c.set(14, c.getActualMinimum(14));
                TimeGranularity.round(c, 13, 10);
                break;
            }
            case FIFTEEN_SECONDS: {
                c.set(14, c.getActualMinimum(14));
                TimeGranularity.round(c, 13, 15);
                break;
            }
            case THIRTY_SECONDS: {
                c.set(14, c.getActualMinimum(14));
                TimeGranularity.round(c, 13, 30);
                break;
            }
            case MINUTE: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                break;
            }
            case FIVE_MINUTES: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                TimeGranularity.round(c, 12, 5);
                break;
            }
            case TEN_MINUTES: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                TimeGranularity.round(c, 12, 10);
                break;
            }
            case FIFTEEN_MINUTES: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                TimeGranularity.round(c, 12, 15);
                break;
            }
            case THIRTY_MINUTES: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                TimeGranularity.round(c, 12, 30);
                break;
            }
            case HOUR: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                break;
            }
            case THREE_HOURS: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                TimeGranularity.round(c, 11, 3);
                break;
            }
            case SIX_HOURS: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                TimeGranularity.round(c, 11, 6);
                break;
            }
            case DAY_TINY: 
            case DAY_SHORT: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                c.set(11, c.getActualMinimum(11));
                break;
            }
            case WEEK: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                c.set(11, c.getActualMinimum(11));
                c.set(7, TimeGranularity.getFirstDayOfWeek());
                break;
            }
            case MONTH_TINY: 
            case MONTH_SHORT: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                c.set(11, c.getActualMinimum(11));
                c.set(5, c.getActualMinimum(5));
                break;
            }
            case QUARTER_YEAR: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                c.set(11, c.getActualMinimum(11));
                c.set(5, c.getActualMinimum(5));
                TimeGranularity.round(c, 2, 3);
                break;
            }
            case HALF_YEAR: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                c.set(11, c.getActualMinimum(11));
                c.set(5, c.getActualMinimum(5));
                TimeGranularity.round(c, 2, 6);
                break;
            }
            case YEAR: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                c.set(11, c.getActualMinimum(11));
                c.set(5, c.getActualMinimum(5));
                c.set(2, c.getActualMinimum(2));
                break;
            }
            case DECADE: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                c.set(11, c.getActualMinimum(11));
                c.set(5, c.getActualMinimum(5));
                c.set(2, c.getActualMinimum(2));
                c.set(1, c.get(1) / 10 * 10);
                break;
            }
            case CENTURY: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                c.set(11, c.getActualMinimum(11));
                c.set(5, c.getActualMinimum(5));
                c.set(2, c.getActualMinimum(2));
                TimeGranularity.round(c, 1, 100);
                break;
            }
            case MILLENIUM: {
                c.set(14, c.getActualMinimum(14));
                c.set(13, c.getActualMinimum(13));
                c.set(12, c.getActualMinimum(12));
                c.set(11, c.getActualMinimum(11));
                c.set(5, c.getActualMinimum(5));
                c.set(2, c.getActualMinimum(2));
                TimeGranularity.round(c, 1, 1000);
                break;
            }
            default: {
                throw new IllegalArgumentException("no adjustment implemented for " + this);
            }
        }
        LOGGER.fine("adjusted calendar: " + c.getTime());
    }

    private static void round(Calendar c, int field, int divider) {
        if (c == null) {
            throw new IllegalArgumentException("calendar can not be NULL");
        }
        int fieldValue = c.get(field);
        c.set(field, fieldValue - fieldValue % divider);
    }

    public long increment(long time, TimeZone timeZone) {
        Date date = new Date(time);
        this.increment(date, timeZone);
        return date.getTime();
    }

    public void increment(Date date, TimeZone timeZone) {
        if (date == null) {
            throw new IllegalArgumentException("date can not be NULL");
        }
        Calendar c = Calendar.getInstance(timeZone);
        c.setTime(date);
        this.increment(c);
        date.setTime(c.getTimeInMillis());
    }

    public void increment(Calendar c) {
        if (c == null) {
            throw new IllegalArgumentException("calendar can not be NULL");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("original calendar: " + c.getTime());
        }
        switch (this) {
            case MILLENIUM: {
                c.add(1, 1000);
                break;
            }
            case CENTURY: {
                c.add(1, 100);
                break;
            }
            case DECADE: {
                c.add(1, 10);
                break;
            }
            case YEAR: {
                c.add(1, 1);
                break;
            }
            case HALF_YEAR: {
                c.add(2, 6);
                break;
            }
            case QUARTER_YEAR: {
                c.add(2, 3);
                break;
            }
            case MONTH_TINY: 
            case MONTH_SHORT: {
                c.add(2, 1);
                break;
            }
            case DAY_TINY: 
            case DAY_SHORT: {
                c.add(5, 1);
                break;
            }
            case WEEK: {
                c.add(3, 1);
                break;
            }
            case SIX_HOURS: {
                c.add(11, 6);
                break;
            }
            case THREE_HOURS: {
                c.add(11, 3);
                break;
            }
            case HOUR: {
                c.add(11, 1);
                break;
            }
            case THIRTY_MINUTES: {
                c.add(12, 30);
                break;
            }
            case FIFTEEN_MINUTES: {
                c.add(12, 15);
                break;
            }
            case TEN_MINUTES: {
                c.add(12, 10);
                break;
            }
            case FIVE_MINUTES: {
                c.add(12, 5);
                break;
            }
            case MINUTE: {
                c.add(12, 1);
                break;
            }
            case THIRTY_SECONDS: {
                c.add(13, 30);
                break;
            }
            case FIFTEEN_SECONDS: {
                c.add(13, 15);
                break;
            }
            case TEN_SECONDS: {
                c.add(13, 10);
                break;
            }
            case FIVE_SECONDS: {
                c.add(13, 5);
                break;
            }
            case SECOND: {
                c.add(13, 1);
                break;
            }
            case TEN_MILLISECONDS: {
                c.add(14, 10);
                break;
            }
            case HUNDRED_MILLISECONDS: {
                c.add(14, 100);
                break;
            }
            case MILLISECOND: {
                c.add(14, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("no incrementation implemented for " + this);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("incremented calendar: " + c.getTime());
        }
    }

    public long decrement(long time, TimeZone timeZone) {
        Date date = new Date(time);
        this.decrement(date, timeZone);
        return date.getTime();
    }

    public void decrement(Date date, TimeZone timeZone) {
        if (date == null) {
            throw new IllegalArgumentException("date can not be NULL");
        }
        Calendar c = Calendar.getInstance(timeZone);
        c.setTime(date);
        this.decrement(c);
        date.setTime(c.getTimeInMillis());
    }

    public void decrement(Calendar c) {
        if (c == null) {
            throw new IllegalArgumentException("calendar can not be NULL");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("original calendar: " + c.getTime());
        }
        switch (this) {
            case MILLENIUM: {
                c.add(1, -1000);
                break;
            }
            case CENTURY: {
                c.add(1, -100);
                break;
            }
            case DECADE: {
                c.add(1, -10);
                break;
            }
            case YEAR: {
                c.add(1, -1);
                break;
            }
            case HALF_YEAR: {
                c.add(2, -6);
                break;
            }
            case QUARTER_YEAR: {
                c.add(2, -3);
                break;
            }
            case MONTH_TINY: 
            case MONTH_SHORT: {
                c.add(2, -1);
                break;
            }
            case DAY_TINY: 
            case DAY_SHORT: {
                c.add(5, -1);
                break;
            }
            case WEEK: {
                c.add(3, -1);
                break;
            }
            case SIX_HOURS: {
                c.add(11, -6);
                break;
            }
            case THREE_HOURS: {
                c.add(11, -3);
                break;
            }
            case HOUR: {
                c.add(11, -1);
                break;
            }
            case THIRTY_MINUTES: {
                c.add(12, -30);
                break;
            }
            case FIFTEEN_MINUTES: {
                c.add(12, -15);
                break;
            }
            case TEN_MINUTES: {
                c.add(12, -10);
                break;
            }
            case FIVE_MINUTES: {
                c.add(12, -5);
                break;
            }
            case MINUTE: {
                c.add(12, -1);
                break;
            }
            case THIRTY_SECONDS: {
                c.add(13, -30);
                break;
            }
            case FIFTEEN_SECONDS: {
                c.add(13, -15);
                break;
            }
            case TEN_SECONDS: {
                c.add(13, -10);
                break;
            }
            case FIVE_SECONDS: {
                c.add(13, -5);
                break;
            }
            case SECOND: {
                c.add(13, -1);
                break;
            }
            case TEN_MILLISECONDS: {
                c.add(14, -10);
                break;
            }
            case HUNDRED_MILLISECONDS: {
                c.add(14, -100);
                break;
            }
            case MILLISECOND: {
                c.add(14, -1);
                break;
            }
            default: {
                throw new IllegalArgumentException("no decrementation implemented for " + this);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("decremented calendar: " + c.getTime());
        }
    }

    public static TimeGranularity[] getRange(TimeGranularity smallest, TimeGranularity largest) {
        if (smallest == null) {
            throw new IllegalArgumentException("smallest granularity can not be NULL");
        }
        if (largest == null) {
            throw new IllegalArgumentException("largest granularity can not be NULL");
        }
        if (smallest.isLarger(largest)) {
            throw new IllegalArgumentException("smallest must be smaller than largest! smallest = " + smallest + " largest = " + largest);
        }
        TimeGranularity[] allGranularities = TimeGranularity.values();
        ArrayList<TimeGranularity> list = new ArrayList<TimeGranularity>();
        for (int i = smallest.ordinal(); i <= largest.ordinal(); ++i) {
            list.add(allGranularities[i]);
        }
        TimeGranularity[] subSet = new TimeGranularity[list.size()];
        list.toArray(subSet);
        return subSet;
    }

    public boolean isInside(TimeGranularity lower, TimeGranularity upper) {
        if (lower == null) {
            throw new IllegalArgumentException("lower granularity can not be NULL");
        }
        if (upper == null) {
            throw new IllegalArgumentException("upper granularity can not be NULL");
        }
        if (!lower.isSmaller(upper) && !lower.equals(upper)) {
            throw new IllegalArgumentException("a must be smaller than b or equal to b");
        }
        return !(!lower.isSmaller(this) && !lower.equals(this) || !upper.isLarger(this) && !upper.equals(this));
    }

    @Override
    public boolean isSmaller(TimeGranularity tg) {
        if (tg == null) {
            throw new IllegalArgumentException("time granularity can not be NULL");
        }
        return this.ordinal() < tg.ordinal();
    }

    @Override
    public boolean isLarger(TimeGranularity tg) {
        if (tg == null) {
            throw new IllegalArgumentException("time granularity can not be NULL");
        }
        return this.ordinal() > tg.ordinal();
    }

    public static TimeGranularity getTimeGranularity(String name) {
        if (name == null) {
            throw new IllegalArgumentException("time granularity name can not be NULL");
        }
        for (TimeGranularity tg : TimeGranularity.values()) {
            if (!tg.getName().equals(name)) continue;
            return tg;
        }
        throw new IllegalArgumentException("unknown time granularity (display name = " + name + ")");
    }

    public double getDelta(ITimeSpan span, TimeZone timeZone) {
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        if (timeZone == null) {
            throw new IllegalArgumentException("time zone can not be NULL");
        }
        Calendar c1 = Calendar.getInstance(timeZone);
        Calendar c2 = Calendar.getInstance(timeZone);
        c1.setTimeInMillis(span.getStartTime());
        c2.setTimeInMillis(span.getEndTime());
        return this.getDelta(c1, c2);
    }

    public double getDelta(Calendar s, Calendar e) {
        if (s == null) {
            throw new IllegalArgumentException("start calendar can not be NULL");
        }
        if (e == null) {
            throw new IllegalArgumentException("end calendar can not be NULL");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("s = " + s.getTime());
            LOGGER.fine("e = " + e.getTime());
            LOGGER.fine("s millis = " + s.getTimeInMillis());
            LOGGER.fine("e millis= " + e.getTimeInMillis());
        }
        if (e.before(s)) {
            throw new IllegalArgumentException("end time must be AFTER start time");
        }
        long millis = e.getTimeInMillis() - s.getTimeInMillis();
        switch (this) {
            case MILLISECOND: {
                return millis;
            }
            case TEN_MILLISECONDS: {
                return (double)millis / 10.0;
            }
            case HUNDRED_MILLISECONDS: {
                return (double)millis / 100.0;
            }
            case SECOND: {
                return (double)millis / 1000.0;
            }
            case FIVE_SECONDS: {
                return (double)millis / 5000.0;
            }
            case TEN_SECONDS: {
                return (double)millis / 10000.0;
            }
            case FIFTEEN_SECONDS: {
                return (double)millis / 15000.0;
            }
            case THIRTY_SECONDS: {
                return (double)millis / 30000.0;
            }
            case MINUTE: {
                return (double)millis / 60000.0;
            }
            case FIVE_MINUTES: {
                return (double)millis / 300000.0;
            }
            case TEN_MINUTES: {
                return (double)millis / 600000.0;
            }
            case FIFTEEN_MINUTES: {
                return (double)millis / 900000.0;
            }
            case THIRTY_MINUTES: {
                return (double)millis / 1800000.0;
            }
            case HOUR: {
                return (double)millis / 3600000.0;
            }
            case THREE_HOURS: {
                return (double)millis / 1.08E7;
            }
            case SIX_HOURS: {
                return (double)millis / 2.16E7;
            }
            case DAY_TINY: 
            case DAY_SHORT: {
                return (double)millis / 8.64E7;
            }
            case WEEK: {
                return (double)millis / 6.048E8;
            }
            case MONTH_TINY: 
            case MONTH_SHORT: {
                return (double)millis / 2.592E9;
            }
            case QUARTER_YEAR: {
                return (double)millis / 7.776E9;
            }
            case HALF_YEAR: {
                return (double)millis / 1.5552E10;
            }
            case YEAR: {
                return (double)millis / 3.1104E10;
            }
            case DECADE: {
                return (double)millis / 3.1104E11;
            }
            case CENTURY: {
                return (double)millis / 3.1104E12;
            }
            case MILLENIUM: {
                return (double)millis / 3.1104E13;
            }
        }
        throw new IllegalArgumentException("unknown time granularity (display name = " + this.name + ")");
    }

    @Override
    public boolean isDisplayingMarkerType(MarkerType type) {
        return this.isSmaller(WEEK);
    }

    public static int getFirstDayOfWeek() {
        return firstDayOfWeek;
    }

    public static void setFirstDayOfWeek(int firstDayOfWeek) {
        TimeGranularity.firstDayOfWeek = firstDayOfWeek;
    }

    @Override
    public String getSingularName() {
        return this.singularName;
    }

    static {
        LOGGER = Logger.getLogger(TimeGranularity.class.getName());
        firstDayOfWeek = Calendar.getInstance().getFirstDayOfWeek();
    }
}

