/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model;

import com.dlsc.flexgantt.model.ITimeSpan;
import java.util.Iterator;
import java.util.List;

public class TimeSpanIterator<T extends ITimeSpan>
implements Iterator<T> {
    private List<T> timeSpanList;
    private int index = -1;
    private ITimeSpan span;

    public TimeSpanIterator(List<T> timeSpanList, ITimeSpan span) {
        if (timeSpanList == null) {
            throw new IllegalArgumentException("time span list can not be NULL");
        }
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        this.timeSpanList = timeSpanList;
        this.span = span;
        this.index = this.findFirstObject();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.timeSpanList.size() > this.index) {
            ITimeSpan obj = (ITimeSpan)this.timeSpanList.get(this.index);
            return obj.getStartTime() <= this.span.getEndTime();
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return (T)((ITimeSpan)this.timeSpanList.get(this.index++));
        }
        throw new UnsupportedOperationException("iterator has no more elements");
    }

    private int findFirstObject() {
        int m = 0;
        int result = 0;
        if (this.timeSpanList != null) {
            int nrOfEntries = this.timeSpanList.size();
            long startTime = this.span.getStartTime();
            long endTime = this.span.getEndTime();
            int low = 0;
            int high = nrOfEntries - 1;
            do {
                m = low + (high - low) / 2;
                ITimeSpan obj = (ITimeSpan)this.timeSpanList.get(m);
                long su = obj.getStartTime();
                long eu = obj.getEndTime();
                if (eu >= startTime && su <= endTime) {
                    high = m - 1;
                    continue;
                }
                if (eu < startTime) {
                    low = m + 1;
                    continue;
                }
                if (su <= endTime) continue;
                high = m - 1;
            } while (high >= low);
            result = low;
            if (low > 0) {
                ITimeSpan obj;
                int i = low = Math.min(low, this.timeSpanList.size() - 1);
                while (low >= 0 && (obj = (ITimeSpan)this.timeSpanList.get(i)).intersects(this.span)) {
                    result = i;
                    --low;
                }
            }
        }
        return result;
    }
}

