/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.eventline;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.eventline.DefaultEventlineModel;
import com.dlsc.flexgantt.model.eventline.IEventlineObject;
import com.dlsc.flexgantt.util.Messages;

public class DefaultDeleteEventlineObjectCommand
extends AbstractCommand {
    private IEventlineObject eventlineObject;
    private DefaultEventlineModel model;

    public DefaultDeleteEventlineObjectCommand(IEventlineObject object, DefaultEventlineModel model) {
        super(Messages.getString("DefaultDeleteEventlineObjectCommand.NAME"));
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (object == null) {
            throw new IllegalArgumentException("eventline object can not be NULL");
        }
        this.eventlineObject = object;
        this.model = model;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.model.removeEventlineObject(this.eventlineObject);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.addEventlineObject(this.eventlineObject);
    }

    public IEventlineObject getEventlineObject() {
        return this.eventlineObject;
    }

    public DefaultEventlineModel getModel() {
        return this.model;
    }
}

