/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.IProgressMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractCompoundCommand<T extends ICommand>
extends AbstractCommand {
    private static final Logger LOGGER = Logger.getLogger(AbstractCompoundCommand.class.getName());
    private List<T> commands = new ArrayList<T>();
    private List<T> executedCommands = new ArrayList<T>();

    public AbstractCompoundCommand(String name) {
        super(name);
    }

    public void addCommand(T cmd) {
        LOGGER.fine("adding command = " + cmd);
        if (cmd == null) {
            throw new IllegalArgumentException("command can not be NULL");
        }
        this.commands.add(cmd);
    }

    public boolean removeCommand(T cmd) {
        LOGGER.fine("removing command = " + cmd);
        if (cmd == null) {
            throw new IllegalArgumentException("command can not be NULL");
        }
        return this.commands.remove(cmd);
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public T getCommand(int index) {
        return (T)((ICommand)this.commands.get(index));
    }

    public void setCommands(T[] cmd) {
        LOGGER.fine("setting commands");
        if (cmd == null) {
            throw new IllegalArgumentException("array of commands can not be NULL");
        }
        for (T c : cmd) {
            LOGGER.fine("  cmd = " + c);
        }
        this.commands.clear();
        for (T c : cmd) {
            this.addCommand(c);
        }
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        LOGGER.entering(AbstractCompoundCommand.class.getName(), "executeCommand()");
        if (monitor == null) {
            throw new IllegalArgumentException("progress monitor can not be NULL");
        }
        monitor.beginTask(this.getName(), this.commands.size());
        this.executedCommands.clear();
        for (ICommand cmd : this.commands) {
            if (!monitor.isCanceled()) {
                LOGGER.fine("executing command = " + cmd);
                cmd.executeCommand(monitor);
                this.executedCommands.add(cmd);
                monitor.worked(1);
                continue;
            }
            LOGGER.fine("compound command was canceled");
        }
        LOGGER.exiting(AbstractCompoundCommand.class.getName(), "executeCommand()");
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        LOGGER.entering(AbstractCompoundCommand.class.getName(), "undoCommand()");
        int s = this.executedCommands.size();
        for (int i = s - 1; i >= 0; --i) {
            ICommand cmd = (ICommand)this.executedCommands.get(i);
            LOGGER.fine("undoing command = " + cmd);
            cmd.undoCommand(monitor);
        }
        LOGGER.exiting(AbstractCompoundCommand.class.getName(), "undoCommand()");
    }

    @Override
    public void redoCommand(IProgressMonitor monitor) throws CommandException {
        LOGGER.entering(AbstractCompoundCommand.class.getName(), "redoCommand()");
        this.executeCommand(monitor);
        LOGGER.exiting(AbstractCompoundCommand.class.getName(), "redoCommand()");
    }

    @Override
    public boolean isUndoable() {
        LOGGER.entering(AbstractCompoundCommand.class.getName(), "isUndoable()");
        for (ICommand cmd : this.commands) {
            LOGGER.fine("checking command = " + cmd);
            if (!cmd.isUndoable()) {
                LOGGER.exiting(AbstractCompoundCommand.class.getName(), "isUndoable()", Boolean.FALSE);
                return false;
            }
            LOGGER.fine("command is undoable");
        }
        LOGGER.exiting(AbstractCompoundCommand.class.getName(), "isUndoable()", Boolean.TRUE);
        return true;
    }

    @Override
    public boolean isRedoable() {
        LOGGER.entering(AbstractCompoundCommand.class.getName(), "isRedoable()");
        int s = this.commands.size();
        for (int i = 0; i < s; ++i) {
            ICommand cmd = (ICommand)this.commands.get(i);
            LOGGER.fine("checking command = " + cmd);
            if (!cmd.isRedoable()) {
                LOGGER.exiting(AbstractCompoundCommand.class.getName(), "isRedoable()", Boolean.FALSE);
                return false;
            }
            LOGGER.fine("command is redoable");
        }
        LOGGER.exiting(AbstractCompoundCommand.class.getName(), "isRedoable()", Boolean.TRUE);
        return true;
    }
}

