/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.util;

import com.smardec.license4j.License;
import com.smardec.license4j.LicenseManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FlexGanttLicenseManager {
    private static final Logger LOGGER = Logger.getLogger(FlexGanttLicenseManager.class.getName());
    public static final String FEATURE_LICENSEE = "LIC";
    public static final String FEATURE_VENDOR = "VEN";
    public static final String FEATURE_RUNTIME = "RUN";
    public static final String FEATURE_VERSION = "VER";
    private static final int SYSTEM_EXIT_CODE = -1603;
    private static License license;
    private static String publicKey;
    private static boolean keySet;

    private FlexGanttLicenseManager() {
    }

    public static void setLicenseKey(String key) {
        if (keySet) {
            throw new IllegalStateException("licensing key can only be set once");
        }
        keySet = true;
        LOGGER.fine("found properties file");
        try {
            key = key.replace(';', '\n');
            ByteArrayInputStream stream = new ByteArrayInputStream(key.getBytes());
            license = LicenseManager.loadLicense((InputStream)stream);
            if (!LicenseManager.isValid((License)license)) {
                System.err.println();
                System.err.println("#####################################");
                System.err.println("# Invalid FlexGantt license key!    #");
                System.err.println("# Exiting application...            #");
                System.err.println("#####################################");
                System.err.println();
                System.exit(-1603);
            }
            List featureNames = license.getFeatureList();
            LOGGER.fine("License Features:");
            for (String featureName : featureNames) {
                Object featureValue = license.getFeature(featureName);
                LOGGER.fine("   " + featureName + " = " + featureValue);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "unable to process flexgantt properties file", e);
            System.err.println("Unable to process flexgantt license file, exiting application");
            System.exit(-1603);
        }
    }

    public static boolean isTrialLicense() {
        return license == null;
    }

    public static boolean isRuntimeLicense() {
        if (license != null) {
            String runtime = (String)license.getFeature(FEATURE_RUNTIME);
            return runtime != null && runtime.equals("yes");
        }
        return false;
    }

    public static boolean isDevelopmentLicense() {
        return !FlexGanttLicenseManager.isTrialLicense() && !FlexGanttLicenseManager.isRuntimeLicense();
    }

    public static String getPublicKey() {
        return publicKey;
    }

    public static String getLicensee() {
        if (license != null) {
            String licensee = (String)license.getFeature(FEATURE_LICENSEE);
            return licensee;
        }
        return "---";
    }

    public static String getVendor() {
        if (license != null) {
            String licensee = (String)license.getFeature(FEATURE_VENDOR);
            return licensee;
        }
        return "---";
    }

    public static String getVersion() {
        if (license != null) {
            String licensee = (String)license.getFeature(FEATURE_VERSION);
            return licensee;
        }
        return "---";
    }

    static {
        Properties props = new Properties();
        try {
            props.load(FlexGanttLicenseManager.class.getResourceAsStream("public_key.properties"));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "unable to process public key property file", e);
        }
        publicKey = props.getProperty("public");
        LicenseManager.setPublicKey((String)publicKey);
    }
}

