/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.TooManyListenersException;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class MultiDropTarget
extends DropTarget {
    private static final Logger LOGGER = Logger.getLogger(MultiDropTarget.class.getName());
    private EventListenerList listenerList = new EventListenerList();

    public MultiDropTarget(Component c, int ops, DropTargetListener dtl) {
        super(c, ops, dtl);
        try {
            super.addDropTargetListener(dtl);
        }
        catch (TooManyListenersException ex) {
            LOGGER.throwing(MultiDropTarget.class.getName(), "<init>", ex);
        }
    }

    @Override
    public void addDropTargetListener(DropTargetListener dtl) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DropTargetListener.class, dtl);
    }

    @Override
    public void removeDropTargetListener(DropTargetListener dtl) {
        if (this.listenerList != null) {
            this.listenerList.remove(DropTargetListener.class, dtl);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        super.dragEnter(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).dragEnter(e);
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        super.dragOver(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).dragOver(e);
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        super.dragExit(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).dragExit(e);
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        super.drop(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).drop(e);
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        super.dropActionChanged(e);
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DropTargetListener.class) continue;
                ((DropTargetListener)listeners[i + 1]).dropActionChanged(e);
            }
        }
    }
}

