/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.action.gantt.RedoActionLabeled;
import com.dlsc.flexgantt.swing.action.gantt.UndoActionLabeled;
import com.dlsc.flexgantt.swing.action.treetable.ClearSelectionAction;
import com.dlsc.flexgantt.swing.action.treetable.CollapseNodeAction;
import com.dlsc.flexgantt.swing.action.treetable.DeleteNodeAction;
import com.dlsc.flexgantt.swing.action.treetable.ExpandNodeAction;
import com.dlsc.flexgantt.swing.action.treetable.IndentNodeAction;
import com.dlsc.flexgantt.swing.action.treetable.InsertNodeAction;
import com.dlsc.flexgantt.swing.action.treetable.OutdentNodeAction;
import com.dlsc.flexgantt.swing.action.treetable.SelectAllNodesAction;
import com.dlsc.flexgantt.swing.treetable.ITreeTableMenuProvider;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.util.MenuCleaner;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.tree.TreePath;

public class DefaultTreeTableMenuProvider
extends JPopupMenu
implements ITreeTableMenuProvider {
    public DefaultTreeTableMenuProvider() {
        super(Messages.getString("DefaultTreeTableMenuProvider.MENU_TITLE"));
    }

    @Override
    public JPopupMenu getPopupMenu(TreeTable table, MouseEvent e, TreePath treePath, TreeTableColumn column) {
        this.removeAll();
        this.add(new SelectAllNodesAction(table));
        this.add(new ClearSelectionAction(table));
        this.add(new JSeparator());
        this.add(new ExpandNodeAction(table));
        this.add(new CollapseNodeAction(table));
        this.add(new JSeparator());
        this.add(new IndentNodeAction(table));
        this.add(new OutdentNodeAction(table));
        this.add(new JSeparator());
        this.add(new UndoActionLabeled<AbstractGanttChart>(table.getGanttChart()));
        this.add(new RedoActionLabeled<AbstractGanttChart>(table.getGanttChart()));
        this.add(new JSeparator());
        int row = table.getRowForPath(treePath);
        if (row == -1) {
            row = Math.max(0, table.getRowCount() - 1);
        }
        this.add(new InsertNodeAction(table, row));
        this.add(new DeleteNodeAction(table));
        MenuCleaner.clean(this);
        return this;
    }
}

