/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.model.treetable.ColumnModelIterator;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class CellFocusManager
implements MouseListener,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(CellFocusManager.class.getName());
    private TreeTable table;
    private int focusedRow = -1;
    private TreeTableColumn focusedColumn;
    private int oldRow = Integer.MIN_VALUE;
    private int oldCol = Integer.MIN_VALUE;

    public CellFocusManager(TreeTable table) {
        this.table = table;
        this.table.addMouseListener(this);
        this.table.addPropertyChangeListener(this);
    }

    public int getFocusedRow() {
        return this.focusedRow;
    }

    public int getFocusedColumnIndex() {
        if (this.focusedColumn != null) {
            return this.table.getColumnIndex(this.focusedColumn);
        }
        return Integer.MIN_VALUE;
    }

    public boolean hasFocus(int row, int column) {
        if (column < -1 || column >= this.table.getColumnCount()) {
            return false;
        }
        TreeTableColumn c = this.table.getColumn(column);
        if (c == null || this.focusedRow == -1 || this.focusedColumn == null) {
            return false;
        }
        return this.focusedRow == row && c.equals(this.focusedColumn);
    }

    public boolean hasFocus() {
        return this.focusedColumn != null && this.focusedRow != -1;
    }

    public void looseFocus() {
        this.focusedColumn = null;
        this.focusedRow = -1;
        this.table.repaint();
    }

    public void focusOnCell(int row, int col) {
        this.focusOnCell(row, this.table.getColumn(col));
    }

    public void focusOnCell(int row, TreeTableColumn column) {
        LOGGER.fine("row = " + row + " col = " + column);
        this.oldRow = this.getFocusedRow();
        this.oldCol = this.getFocusedColumnIndex();
        this.focusedRow = row;
        this.focusedColumn = column;
        this.updateTable();
    }

    public void focusOnFirstCell() {
        this.focusOnCell(0, -1);
    }

    public void focusOnLastCell() {
        this.focusOnCell(this.table.getRowCount() - 1, -1);
    }

    public void focusOnPageUp() {
        Rectangle rect = this.table.getVisibleRect();
        JViewport view = this.getViewport();
        Point p = view.getViewPosition();
        int y = Math.max(0, p.y - rect.height);
        int newRow = this.table.getRowAt(y);
        if (newRow == -1) {
            newRow = 0;
        }
        if (newRow < this.table.getRowCount()) {
            this.setFocusedRow(newRow);
        }
    }

    public void focusOnPageDown() {
        Rectangle rect = this.table.getVisibleRect();
        JViewport view = this.getViewport();
        Point p = view.getViewPosition();
        int y = Math.min(this.table.getHeight() - 1, p.y + 2 * rect.height);
        int newRow = this.table.getRowAt(y);
        if (newRow == -1) {
            newRow = this.table.getRowCount() - 1;
        }
        if (newRow != -1) {
            this.setFocusedRow(newRow);
        }
    }

    public void focusOnFirstVisibleCell() {
        JViewport view = this.getViewport();
        Point p = view.getViewPosition();
        int y = Math.min(this.table.getHeight() - 1, p.y);
        int newRow = this.table.getRowAt(y);
        if (newRow == -1) {
            newRow = this.table.getRowCount() - 1;
        }
        if (newRow != -1) {
            this.setFocusedRow(newRow);
        }
    }

    private JViewport getViewport() {
        for (Container parent = this.table.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JViewport)) continue;
            return (JViewport)parent;
        }
        throw new IllegalStateException("tree table must be located inside a viewport");
    }

    public void focusOnCellNext() {
        LOGGER.fine("focus on NEXT cell");
        this.oldRow = this.getFocusedRow();
        this.oldCol = this.getFocusedColumnIndex();
        IColumnModel model = this.table.getColumnModel();
        AbstractGanttChart ganttChart = this.table.getGanttChart();
        int kp = ganttChart.getKeyColumnPosition();
        ColumnModelIterator iter = new ColumnModelIterator(model, kp);
        if (this.focusedColumn == null) {
            this.focusedColumn = iter.next();
        } else {
            TreeTableColumn firstColumn = null;
            while (iter.hasNext()) {
                TreeTableColumn c = iter.next();
                if (firstColumn == null) {
                    firstColumn = c;
                }
                if (c != this.focusedColumn) continue;
                try {
                    this.focusedColumn = iter.next();
                }
                catch (NoSuchElementException e) {
                    this.focusedColumn = null;
                }
                break;
            }
            if (this.focusedColumn == null) {
                this.focusedColumn = firstColumn;
                this.calculateCellBelow();
            }
        }
        this.updateTable();
    }

    public void focusOnCellPrevious() {
        LOGGER.fine("focus on PREVIOUS cell");
        this.oldRow = this.getFocusedRow();
        this.oldCol = this.getFocusedColumnIndex();
        IColumnModel model = this.table.getColumnModel();
        AbstractGanttChart ganttChart = this.table.getGanttChart();
        int kp = ganttChart.getKeyColumnPosition();
        ColumnModelIterator iter = new ColumnModelIterator(model, kp);
        if (this.focusedColumn == null) {
            this.focusedColumn = iter.next();
        } else {
            TreeTableColumn c;
            TreeTableColumn lastColumn = null;
            while (iter.hasNext()) {
                c = iter.next();
                if (c.equals(this.focusedColumn)) {
                    this.focusedColumn = lastColumn;
                    break;
                }
                lastColumn = c;
            }
            if (this.focusedColumn == null) {
                iter = new ColumnModelIterator(model, kp);
                if (this.focusedRow == 0) {
                    this.focusedColumn = iter.next();
                } else {
                    while (iter.hasNext()) {
                        c = iter.next();
                        if (iter.hasNext()) continue;
                        this.focusedColumn = c;
                        break;
                    }
                }
                this.calculateCellAbove();
            }
        }
        this.updateTable();
    }

    public void focusOnCellAbove() {
        LOGGER.fine("focus on ABOVE cell");
        this.oldRow = this.getFocusedRow();
        this.oldCol = this.getFocusedColumnIndex();
        this.calculateCellAbove();
        this.updateTable();
    }

    public void focusOnCellBelow() {
        LOGGER.fine("focus on BELOW cell");
        this.oldRow = this.getFocusedRow();
        this.oldCol = this.getFocusedColumnIndex();
        this.calculateCellBelow();
        this.updateTable();
    }

    private void calculateCellAbove() {
        if (this.focusedRow == -1) {
            this.focusedRow = this.table.getFirstVisibleRow();
            this.focusedColumn = this.table.getColumn(-1);
        } else if (this.focusedRow > 0) {
            --this.focusedRow;
        }
    }

    private void calculateCellBelow() {
        if (this.focusedRow == -1) {
            this.focusedRow = this.table.getFirstVisibleRow();
            this.focusedColumn = this.table.getColumn(-1);
        } else if (this.focusedRow < this.table.getRowCount() - 1) {
            ++this.focusedRow;
        }
    }

    private void updateTable() {
        this.updateTable(null);
    }

    private void updateTable(MouseEvent e) {
        int newRow = this.getFocusedRow();
        int newCol = this.getFocusedColumnIndex();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("oldRow = " + this.oldRow + " oldCol = " + this.oldCol + " newRow = " + newRow + " newCol = " + newCol);
        }
        this.table.scrollFocusToVisible();
        this.table.repaint();
    }

    public TreeTableColumn getFocusedColumn() {
        return this.focusedColumn;
    }

    public void setFocusedColumn(TreeTableColumn column) {
        this.focusedColumn = column;
        this.updateTable();
    }

    public TreePath getFocusedPath() {
        if (this.focusedRow != -1) {
            return this.table.getTreePath(this.focusedRow);
        }
        return null;
    }

    public void setFocusedPath(TreePath path) {
        this.setFocusedRow(this.table.getRowForPath(path));
    }

    public void setFocusedRow(int row) {
        this.focusedRow = row;
        this.updateTable();
    }

    public TreeTable getTreeTable() {
        return this.table;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.table.isEnabled() && SwingUtilities.isLeftMouseButton(e) && !e.isPopupTrigger()) {
            int row = this.table.getRowAt(e.getY());
            int column = this.table.getColumnIndexAt(e.getX());
            LOGGER.fine("row = " + row + " focusedColumn = " + column);
            if (row == -1) {
                column = -1;
            }
            if (row != -1) {
                this.focusedRow = row;
            }
            LOGGER.fine("focusedRow = " + this.focusedRow);
            this.focusedColumn = column == Integer.MIN_VALUE ? this.table.getKeyColumn() : this.table.getColumn(column);
            LOGGER.fine("focusedColumn = " + this.focusedColumn);
            this.updateTable(e);
            AbstractGanttChart gc = this.table.getGanttChart();
            for (TreeTable tt : gc.getTreeTables()) {
                if (tt == this.table) continue;
                CellFocusManager otherMgr = tt.getCellFocusManager();
                otherMgr.looseFocus();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.table) && evt.getPropertyName().equals("enabled")) {
            this.looseFocus();
        }
    }
}

