/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.AbstractDatelineModel;
import com.dlsc.flexgantt.model.dateline.SimpleGranularity;
import com.dlsc.flexgantt.swing.timeline.AbstractDatelineRenderer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.SimpleGranularityDatelineModel;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.border.EmptyBorder;

public class SimpleGranularityDatelineRenderer<T extends SimpleGranularityDatelineModel>
extends AbstractDatelineRenderer<T> {
    private final Icon ARROW_ICON = new ArrowIcon();

    public SimpleGranularityDatelineRenderer() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(0, 4, 0, 0));
    }

    @Override
    public Component getDatelineRendererComponent(Dateline dateline, T model, ITimeSpan timeSpan, boolean major, boolean focus) {
        super.getDatelineRendererComponent(dateline, model, timeSpan, major, focus);
        String text = null;
        if (major) {
            SimpleGranularity tg = ((SimpleGranularityDatelineModel)model).getMajorSimpleGranularity();
            text = ((SimpleGranularityDatelineModel)model).getMajorDateString(tg, timeSpan.getStartTime());
            this.setForeground(this.getMajorForeground(dateline, timeSpan.getStartTime()));
            this.setBackground(this.getMajorBackground(dateline, timeSpan.getStartTime()));
            this.setIcon(this.ARROW_ICON);
            this.setHorizontalAlignment(2);
        } else {
            SimpleGranularity tg = (SimpleGranularity)((AbstractDatelineModel)model).getGranularity();
            text = ((SimpleGranularityDatelineModel)model).getMinorDateString(tg, timeSpan.getStartTime());
            if (text.equals("0")) {
                text = "";
            }
            this.setForeground(this.getMinorForeground(dateline, timeSpan.getStartTime()));
            this.setBackground(this.getMinorBackground(dateline, timeSpan.getStartTime()));
            this.setIcon(null);
            this.setHorizontalAlignment(0);
        }
        this.setEnabled(dateline.isEnabled());
        this.setText(text);
        return this;
    }

    class ArrowIcon
    implements Icon {
        ArrowIcon() {
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(c.getForeground());
            int mx = x + this.getIconWidth() / 2;
            int my = y + this.getIconHeight();
            for (int i = 0; i < 4; ++i) {
                g.drawLine(mx - i, my - i, mx + i, my - i);
            }
        }
    }
}

