/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.command.dateline.DefaultChangeTimeZoneCommand;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.TimeZonePanel;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimeZoneSelector
extends Selector {
    private TimeZonePanel timeZonePanel;
    private AbstractGanttChart ganttChart;
    private JTextField textField;
    private JButton okButton;
    private JButton cancelButton;

    public TimeZoneSelector(JComponent parentComponent, AbstractGanttChart gc) {
        super(Messages.getString("TimeZoneSelector.TITLE"), parentComponent, Selector.Location.ABOVE);
        if (gc == null) {
            throw new IllegalArgumentException("Gantt chart can not be NULL");
        }
        this.ganttChart = gc;
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(10, 10));
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        content.setOpaque(false);
        this.textField = new JTextField();
        this.textField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                TimeZoneSelector.this.timeZonePanel.setFilter(TimeZoneSelector.this.textField.getText());
            }
        });
        content.add("North", this.textField);
        this.timeZonePanel = new TimeZonePanel();
        this.timeZonePanel.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TimeZoneSelector.this.okPressed();
                }
            }
        });
        this.timeZonePanel.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TimeZoneSelector.this.timeZonePanel.getList().getSelectedValue() != null) {
                    TimeZoneSelector.this.okButton.setEnabled(true);
                } else {
                    TimeZoneSelector.this.okButton.setEnabled(false);
                }
            }
        });
        this.timeZonePanel.requestFocusInWindow();
        content.add("Center", this.timeZonePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(Messages.getString("TimeZoneSelector.OK"));
        this.okButton.setOpaque(false);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(Messages.getString("TimeZoneSelector.CANCEL"));
        this.cancelButton.setOpaque(false);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeZoneSelector.this.okPressed();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeZoneSelector.this.cancelPressed();
            }
        });
        content.add("South", buttonPanel);
        this.add("Center", content);
        this.setContentComponent(content);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.timeZonePanel.setSelectedTimeZone(this.ganttChart.getDatelineModel().getTimeZone());
        }
        super.setVisible(b);
    }

    protected void okPressed() {
        TimeZone selectedTimeZone = this.timeZonePanel.getSelectedTimeZone();
        if (selectedTimeZone != null) {
            DefaultChangeTimeZoneCommand cmd = new DefaultChangeTimeZoneCommand(this.ganttChart.getDatelineModel(), selectedTimeZone);
            this.ganttChart.commandExecute(cmd);
        }
        this.setVisible(false);
    }

    protected void cancelPressed() {
        this.setVisible(false);
    }

    public TimeZonePanel getTimeZonePanel() {
        return this.timeZonePanel;
    }

    public void setSelectedTimeZone(TimeZone zone) {
        this.timeZonePanel.setSelectedTimeZone(zone);
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

