/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.icons.BlankIcon;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GranularitySelector
extends Selector {
    public GranularitySelector(JComponent comp, Dateline dateline) {
        super(Messages.getString("GranularitySelector.TITLE"), comp, Selector.Location.LEFT);
        this.setContentComponent(new GranularityPanel(dateline));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GranularityPanel gp = (GranularityPanel)this.getContentComponent();
            gp.updateList();
        }
        super.setVisible(visible);
    }

    private class GranularityPanel
    extends JPanel
    implements ListSelectionListener {
        private JList list;
        private Dateline dateline;
        private int focusedRow = -1;

        protected GranularityPanel(Dateline dateline) {
            this.dateline = dateline;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.list = new JList();
            this.list.setCellRenderer(new GranularityListRenderer());
            this.list.setOpaque(false);
            this.list.setSelectionMode(0);
            this.list.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.list.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int row = GranularityPanel.this.list.locationToIndex(e.getPoint());
                    if (row != GranularityPanel.this.focusedRow) {
                        GranularityPanel.this.focusedRow = row;
                        GranularityPanel.this.repaint();
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    GranularityPanel.this.focusedRow = -1;
                    GranularityPanel.this.repaint();
                }
            });
            JScrollPane scroll = new JScrollPane(this.list);
            scroll.setBorder(null);
            scroll.setOpaque(false);
            scroll.setViewportBorder(null);
            scroll.getViewport().setBorder(null);
            scroll.getViewport().setOpaque(false);
            scroll.setVerticalScrollBarPolicy(21);
            this.add("Center", scroll);
            this.updateList();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                IGranularity granularity = (IGranularity)this.list.getSelectedValue();
                this.dateline.setGranularity(granularity);
                GranularitySelector.this.setVisible(false);
            }
        }

        private void updateList() {
            this.list.getSelectionModel().removeListSelectionListener(this);
            IPolicyProvider pp = this.dateline.getPolicyProvider();
            IZoomPolicy zp = pp.getPolicy(IZoomPolicy.class);
            int count = zp.getGranularityCount();
            DefaultListModel listModel = new DefaultListModel();
            for (int i = 0; i < count; ++i) {
                Object granularity = zp.getGranularity(i);
                listModel.addElement(granularity);
            }
            this.list.setModel(listModel);
            this.list.setVisibleRowCount(count);
            IGranularity current = this.dateline.getGranularity();
            this.list.setSelectedValue(current, true);
            this.list.getSelectionModel().addListSelectionListener(this);
        }

        private class GranularityListRenderer
        extends JLabel
        implements ListCellRenderer {
            private Icon selectionIcon;
            private Icon notSelectedIcon;
            private boolean focused;

            protected GranularityListRenderer() {
                this.setOpaque(false);
                this.selectionIcon = IconRegistry.getIcon(IconId.SELECTION_INDICATOR);
                this.notSelectedIcon = new BlankIcon(this.selectionIcon.getIconWidth(), this.selectionIcon.getIconHeight());
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                IGranularity granularity = (IGranularity)value;
                this.setText(granularity.getName());
                this.setForeground(Color.BLACK);
                if (isSelected) {
                    this.setIcon(this.selectionIcon);
                } else {
                    this.setIcon(this.notSelectedIcon);
                }
                this.focused = index == GranularityPanel.this.focusedRow;
                this.setOpaque(this.focused);
                if (this.focused) {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.BLACK);
                }
                return this;
            }
        }
    }
}

