/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.AbstractGanttChartActionMap;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.util.TableUtils;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ActionSelector
extends Selector {
    public ActionSelector(JComponent parentComponent, AbstractGanttChart gc) {
        super(Messages.getString("ActionSelector.TITLE"), parentComponent, Selector.Location.ABOVE);
        Box box = new Box(1);
        box.setOpaque(false);
        AbstractGanttChartActionMap actionMap = (AbstractGanttChartActionMap)gc.getActionMap();
        Iterator<String> categories = actionMap.getCategories();
        int actionColumnWidth = 0;
        while (categories.hasNext()) {
            KeyStrokePanel panel = new KeyStrokePanel(categories.next(), actionMap, gc);
            actionColumnWidth = Math.max(actionColumnWidth, panel.getActionColumn().getPreferredWidth());
            box.add(panel);
        }
        for (Component comp : box.getComponents()) {
            KeyStrokePanel panel = (KeyStrokePanel)comp;
            TableColumn col = panel.getActionColumn();
            col.setMinWidth(actionColumnWidth);
            col.setMaxWidth(actionColumnWidth);
        }
        JScrollPane pane = new JScrollPane(box);
        pane.setOpaque(false);
        pane.getViewport().setOpaque(false);
        pane.setBorder(null);
        pane.setMaximumSize(new Dimension(400, 300));
        this.setContentComponent(pane);
    }

    class SelectorRenderer
    extends DefaultTableCellRenderer {
        SelectorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setOpaque(false);
            this.setFont(table.getFont());
            this.setIcon(null);
            if (column == 1) {
                this.setFont(this.getFont().deriveFont(1));
            }
            if (value instanceof Action) {
                Action action = (Action)value;
                this.setText((String)action.getValue("Name"));
                Icon icon = (Icon)action.getValue("SmallIcon");
                if (icon == null) {
                    icon = IconRegistry.getIcon(IconId.BLANK);
                }
                this.setIcon(icon);
            } else if (value instanceof KeyStroke[]) {
                KeyStroke[] strokes = (KeyStroke[])value;
                StringBuffer sb = new StringBuffer();
                int l = strokes.length;
                for (int i = 0; i < l; ++i) {
                    KeyStroke stroke = strokes[i];
                    String modText = "";
                    if (stroke.getModifiers() != 0) {
                        modText = KeyEvent.getKeyModifiersText(stroke.getModifiers()) + "+";
                    }
                    String keyText = KeyEvent.getKeyText(stroke.getKeyCode());
                    if (i < l - 1) {
                        sb.append(modText + keyText + ", ");
                        continue;
                    }
                    sb.append(modText + keyText);
                }
                this.setText(sb.toString());
            }
            return comp;
        }
    }

    class KeyStrokePanel
    extends JPanel {
        private TableColumn actionColumn;

        protected KeyStrokePanel(String category, AbstractGanttChartActionMap actionMap, AbstractGanttChart gc) {
            this.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new TitledBorder(category)));
            this.setOpaque(false);
            String actionColumnName = Messages.getString("ActionSelector.COLUMN_TEXT");
            Object[] cols = new String[]{actionColumnName, Messages.getString("ActionSelector.COLUMN_STROKE")};
            Iterator<String> actions = actionMap.getCategoryActions(category);
            LinkedList<String> actionList = new LinkedList<String>();
            while (actions.hasNext()) {
                String action = actions.next();
                actionList.add(action);
            }
            int s = actionList.size();
            Object[][] rows = new Object[s][2];
            for (int i = 0; i < s; ++i) {
                String actionId = (String)actionList.get(i);
                Action action = actionMap.get(actionId);
                rows[i][0] = action;
                rows[i][1] = this.getKeyStrokes(actionId, gc);
            }
            final JTable table = new JTable(rows, cols){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            table.setRowHeight(Math.max(table.getFontMetrics(table.getFont()).getHeight(), IconRegistry.getIconDimension().height + 2));
            table.setRowSelectionAllowed(false);
            table.setColumnSelectionAllowed(false);
            table.setShowGrid(false);
            table.setDefaultRenderer(Object.class, new SelectorRenderer());
            table.setOpaque(false);
            this.setLayout(new BorderLayout());
            TableUtils.autoResizeTable(table, false, 10);
            this.add("North", table);
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    Action action;
                    if (e.getClickCount() == 1 && (action = (Action)table.getValueAt(row = table.rowAtPoint(e.getPoint()), 0)) != null) {
                        String cmd = (String)action.getValue("ActionCommandKey");
                        ActionEvent actionEvent = new ActionEvent(table, 1001, cmd);
                        action.actionPerformed(actionEvent);
                    }
                }
            });
            this.actionColumn = table.getColumn(actionColumnName);
        }

        private KeyStroke[] getKeyStrokes(Object actionId, AbstractGanttChart gc) {
            int[] types;
            LinkedList<KeyStroke> result = new LinkedList<KeyStroke>();
            int[] nArray = types = new int[]{0, 1, 2};
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer mapType = nArray[i];
                InputMap map = gc.getInputMap(mapType);
                KeyStroke[] strokes = map.keys();
                if (strokes == null) continue;
                for (KeyStroke stroke : strokes) {
                    Object id = map.get(stroke);
                    if (!id.equals(actionId)) continue;
                    result.add(stroke);
                }
            }
            int s = result.size();
            KeyStroke[] ks = new KeyStroke[s];
            return result.toArray(ks);
        }

        public TableColumn getActionColumn() {
            return this.actionColumn;
        }
    }
}

