/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.mac;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.swing.DualGanttChart;
import com.dlsc.flexgantt.swing.IComponentFactory;
import com.dlsc.flexgantt.swing.NavigationControl;
import com.dlsc.flexgantt.swing.NavigationControlPanel;
import com.dlsc.flexgantt.swing.NavigationControlType;
import com.dlsc.flexgantt.swing.PagingControl;
import com.dlsc.flexgantt.swing.PagingControlPanel;
import com.dlsc.flexgantt.swing.PagingControlType;
import com.dlsc.flexgantt.swing.UtilityControlPanel;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.layer.system.DatelineLayer;
import com.dlsc.flexgantt.swing.mac.MacComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class MacDualGanttChart
extends DualGanttChart {
    public MacDualGanttChart(IGanttChartModel primaryModel, IGanttChartModel secondaryModel, IColumnModel columnModel) {
        super(primaryModel, secondaryModel, columnModel, MacComponentFactory.getInstance());
        this.init();
    }

    public MacDualGanttChart(IGanttChartModel primaryModel, IGanttChartModel secondaryModel) {
        super(primaryModel, secondaryModel, (IComponentFactory)MacComponentFactory.getInstance());
        this.init();
    }

    public MacDualGanttChart(IGanttChartModel model) {
        super(model, model, (IComponentFactory)MacComponentFactory.getInstance());
        this.init();
    }

    public MacDualGanttChart(MacComponentFactory compFactory) {
        super(compFactory);
        this.init();
    }

    public MacDualGanttChart() {
        super(MacComponentFactory.getInstance());
        this.init();
    }

    private void init() {
        LayerContainerScrollPane[] allLcsp;
        LayerContainer lc = this.getPrimaryLayerContainer();
        lc.getSystemLayer(DatelineLayer.class).setFocusedTimeVisible(false);
        lc.getSystemLayer(DatelineLayer.class).setHorizonLimitsVisible(false);
        lc = this.getSecondaryLayerContainer();
        lc.getSystemLayer(DatelineLayer.class).setFocusedTimeVisible(false);
        lc.getSystemLayer(DatelineLayer.class).setHorizonLimitsVisible(false);
        for (LayerContainerScrollPane lcsp : allLcsp = this.getLayerContainerScrollPanes()) {
            NavigationControlPanel ncp = (NavigationControlPanel)lcsp.getCorner("UPPER_RIGHT_CORNER");
            for (NavigationControlType type : NavigationControlType.values()) {
                NavigationControl nc = ncp.getNavigationControl(type);
                if (nc == null) continue;
                nc.setOpaque(true);
                nc.setBackground(new Color(230, 230, 230));
            }
            UtilityControlPanel ucp = (UtilityControlPanel)lcsp.getCorner("LOWER_LEFT_CORNER");
            for (Component comp : ucp.getComponents()) {
                JComponent jc = (JComponent)comp;
                jc.setOpaque(true);
                jc.setBackground(new Color(230, 230, 230));
            }
            PagingControlPanel pcp = ucp.getPagingControlPanel();
            for (PagingControlType pct : PagingControlType.values()) {
                PagingControl pc = pcp.getPagingControl(pct);
                pc.setOpaque(true);
                pc.setBackground(new Color(230, 230, 230));
            }
        }
        Border vSplitterBorder = new Border(){
            private Insets insets = new Insets(1, 1, 1, 1);

            @Override
            public Insets getBorderInsets(Component c) {
                return this.insets;
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(new GradientPaint(x, y, Color.WHITE, x + width, y, Color.LIGHT_GRAY));
                g2d.fillRect(x, y, width, height);
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(x, y, x, y + height);
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            }
        };
        JComponent vSplitter = this.getVerticalSplitter();
        vSplitter.setBorder(vSplitterBorder);
        Border hSplitterBorder = new Border(){
            Insets insets = new Insets(0, 0, 0, 0);

            @Override
            public Insets getBorderInsets(Component c) {
                return this.insets;
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(new GradientPaint(x, y, Color.WHITE, x, y + height, Color.LIGHT_GRAY));
                g2d.fillRect(x, y, width, height);
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(x, y, x + width, y);
                g2d.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
        };
        JComponent hSplitter = this.getHorizontalSplitter();
        hSplitter.setBorder(hSplitterBorder);
    }
}

