/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.model.gantt.DefaultActivityObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Editor
extends JPanel
implements ChangeListener {
    private JSlider slider;
    private JLabel valueLabel;
    private DefaultActivityObject activityObject;

    protected Editor() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(10, 10));
        this.slider = new JSlider(0, 0, 100, 0);
        this.slider.setMajorTickSpacing(25);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.setOpaque(false);
        this.add("Center", this.slider);
        this.valueLabel = new JLabel();
        this.valueLabel.setText("99%");
        this.valueLabel.setForeground(Color.WHITE);
        this.valueLabel.setBackground(Color.BLACK);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont(14.0f));
        this.valueLabel.setOpaque(true);
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setPreferredSize(new Dimension(50, 10));
        this.add("East", this.valueLabel);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Editor.this.updateLabel();
            }
        });
    }

    private void updateLabel() {
        this.valueLabel.setText(this.slider.getValue() + "%");
    }

    protected void setActivityObject(DefaultActivityObject object) {
        this.activityObject = object;
        this.slider.setValue((int)object.getPercentageComplete());
        this.updateLabel();
    }

    private void applyValue() {
        this.activityObject.setPercentageComplete(this.slider.getValue());
    }

    protected boolean stopEditing() {
        this.applyValue();
        return true;
    }

    protected void cancelEditing() {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.applyValue();
    }
}

