/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.system.EditingLayer;
import com.dlsc.flexgantt.swing.layer.timeline.AbstractTimelineObjectEditor;
import com.dlsc.flexgantt.swing.layer.timeline.TextFieldEditor;
import com.dlsc.flexgantt.util.LabelType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class DefaultTimelineObjectEditor
extends AbstractTimelineObjectEditor {
    private JTextField textField;

    public DefaultTimelineObjectEditor() {
        super(new TextFieldEditor());
        TextFieldEditor editor = (TextFieldEditor)this.getContent();
        this.textField = editor.getTextField();
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultTimelineObjectEditor.this.stopEditing();
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    DefaultTimelineObjectEditor.this.cancelEditing();
                }
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DefaultTimelineObjectEditor.this.cancelEditing();
            }
        });
    }

    @Override
    public Component getTimelineObjectEditorComponent(EditingLayer layer, TimelineObjectPath path) {
        super.getTimelineObjectEditorComponent(layer, path);
        DefaultTimelineObject obj = (DefaultTimelineObject)this.getTimelineObject();
        this.textField.setText(obj.getLabel(LabelType.NAME));
        return this;
    }

    @Override
    public void cancelEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopEditing() {
        String text = this.textField.getText();
        ((DefaultTimelineObject)this.getTimelineObject()).setLabel(text, LabelType.NAME);
        this.fireEditingStopped();
        return true;
    }
}

