/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.swing.layer.AbstractCustomLayer;
import com.dlsc.flexgantt.swing.layer.ILayerFactory;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Graphics;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;

public class DefaultLayerFactory
implements ILayerFactory {
    private static final Logger LOGGER = Logger.getLogger(DefaultLayerFactory.class.getName());
    private static ILayerFactory instance;

    protected DefaultLayerFactory() {
    }

    public static synchronized ILayerFactory getInstance() {
        if (instance == null) {
            instance = new DefaultLayerFactory();
        }
        return instance;
    }

    @Override
    public <T extends AbstractSystemLayer> T createSystemLayer(LayerContainer lc, Class<T> layerType) {
        if (lc == null) {
            throw new IllegalArgumentException("layer container can not be NULL");
        }
        if (layerType == null) {
            throw new IllegalArgumentException("layer type can not be NULL");
        }
        LOGGER.fine("creating system layer of type = " + layerType.getName());
        try {
            Constructor<T> con = layerType.getConstructor(LayerContainer.class);
            return (T)((AbstractSystemLayer)con.newInstance(lc));
        }
        catch (Exception ex) {
            LOGGER.throwing(this.getClass().getName(), "createSystemLayer", ex);
            throw new IllegalStateException("factory was unable to create a system layer of type " + layerType.getName(), ex);
        }
    }

    @Override
    public TimelineObjectLayer createTimelineLayer(LayerContainer lc, ILayer layer) {
        return new TimelineObjectLayer(lc, layer);
    }

    @Override
    public AbstractCustomLayer createCustomLayer(LayerContainer lc, ILayer layer) {
        return new MissingCustomLayer(lc, layer);
    }

    class MissingCustomLayer
    extends AbstractCustomLayer {
        public MissingCustomLayer(LayerContainer lc, ILayer layer) {
            super(lc, layer);
        }

        @Override
        protected void paintLayer(Graphics g) {
            super.paintLayer(g);
            g.setColor(this.getLayerContainer().getForeground());
            g.setFont(g.getFont().deriveFont(32));
            g.drawString(Messages.getString("DefaultLayerFactory.MISSING_CUSTOM_LAYER_IMPLEMENTATION"), 100, 100);
        }
    }
}

