/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.TimeSpanIterator;
import com.dlsc.flexgantt.swing.layer.ILayerContainerSelectionModel;
import com.dlsc.flexgantt.swing.layer.ILayerContainerSelectionModelListener;
import com.dlsc.flexgantt.swing.layer.TimeSpanSelectionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DefaultLayerContainerSelectionModel
implements ILayerContainerSelectionModel {
    private static final Logger LOGGER = Logger.getLogger(DefaultLayerContainerSelectionModel.class.getName());
    private static final Iterator<ITimeSpan> EMPTY_ITERATOR = new Iterator<ITimeSpan>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ITimeSpan next() {
            throw new IllegalStateException("the empty iterator can not return any elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("nothing can be removed from the empty iterator");
        }
    };
    private EventListenerList listenerList = new EventListenerList();
    private Map<Object, List<ITimeSpan>> spanMap = new HashMap<Object, List<ITimeSpan>>();

    @Override
    public boolean isEmpty() {
        return this.spanMap.isEmpty();
    }

    @Override
    public boolean isEmpty(Object node) {
        return !this.spanMap.containsKey(node);
    }

    @Override
    public void clearSelectedTimeSpans() {
        LOGGER.fine("clearing all time span selections for all nodes");
        for (Object node : new HashSet<Object>(this.spanMap.keySet())) {
            this.clearSelectedTimeSpans(node);
        }
    }

    @Override
    public void clearSelectedTimeSpans(Object node) {
        LOGGER.fine("clearing time span selections for node = " + node);
        List<ITimeSpan> oldSelection = this.spanMap.get(node);
        this.spanMap.remove(node);
        this.fireTimeSpansRemoved(node, oldSelection);
    }

    @Override
    public void addSelectedTimeSpan(Object node, ITimeSpan span) {
        List<ITimeSpan> spanList;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("adding a selected time span for node = " + node);
            LOGGER.fine("time span = " + span);
        }
        if ((spanList = this.spanMap.get(node)) == null) {
            spanList = new ArrayList<ITimeSpan>();
            this.spanMap.put(node, spanList);
        }
        spanList.add(span);
        Collections.sort(spanList);
        ArrayList<ITimeSpan> list = new ArrayList<ITimeSpan>();
        list.add(span);
        this.fireTimeSpansAdded(node, list);
    }

    @Override
    public void removeSelectedTimeSpan(Object node, ITimeSpan removedSpan) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("removing a selected time span from node = " + node);
            LOGGER.fine("time span = " + removedSpan);
        }
        List<ITimeSpan> spanList = this.spanMap.get(node);
        ArrayList<TimeSpan> addList = new ArrayList<TimeSpan>();
        ArrayList<ITimeSpan> removeList = new ArrayList<ITimeSpan>();
        if (spanList != null) {
            for (int i = 0; i < spanList.size(); ++i) {
                ITimeSpan s = spanList.get(i);
                if (!s.intersects(removedSpan)) continue;
                if (removedSpan.getStartTime() > s.getStartTime() && removedSpan.getEndTime() < s.getEndTime()) {
                    TimeSpan newSpan = new TimeSpan(removedSpan.getEndTime(), s.getEndTime());
                    addList.add(newSpan);
                    addList.add(new TimeSpan(s.getStartTime(), removedSpan.getStartTime()));
                } else if (removedSpan.getStartTime() > s.getStartTime()) {
                    addList.add(new TimeSpan(s.getStartTime(), removedSpan.getStartTime()));
                } else {
                    addList.add(new TimeSpan(removedSpan.getEndTime(), s.getEndTime()));
                }
                for (ITimeSpan iTimeSpan : addList) {
                    spanList.add(iTimeSpan);
                }
                removeList.add(s);
            }
            for (ITimeSpan span : removeList) {
                spanList.remove(span);
            }
            Collections.sort(spanList);
            ArrayList<ITimeSpan> list = new ArrayList<ITimeSpan>();
            list.add(removedSpan);
            this.fireTimeSpansRemoved(node, list);
        }
    }

    @Override
    public Iterator<ITimeSpan> getSelectedTimeSpans(Object owner, ITimeSpan span) {
        List<ITimeSpan> list = this.spanMap.get(owner);
        if (list != null && list.size() > 0) {
            TimeSpanIterator<ITimeSpan> iterator = new TimeSpanIterator<ITimeSpan>(list, span);
            return iterator;
        }
        return EMPTY_ITERATOR;
    }

    @Override
    public boolean isSelected(Object node, ITimeSpan span) {
        List<ITimeSpan> list = this.spanMap.get(node);
        if (list != null) {
            for (ITimeSpan ts : list) {
                if (!ts.contains(span)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addLayerContainerSelectionModelListener(ILayerContainerSelectionModelListener l) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ILayerContainerSelectionModelListener.class, l);
    }

    @Override
    public void removeLayerContainerSelectionModelListener(ILayerContainerSelectionModelListener l) {
        if (this.listenerList != null) {
            this.listenerList.remove(ILayerContainerSelectionModelListener.class, l);
        }
    }

    protected void fireTimeSpansAdded(Object node, List<ITimeSpan> spans) {
        Object[] listeners = this.listenerList.getListenerList();
        TimeSpanSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ILayerContainerSelectionModelListener.class) continue;
            if (e == null) {
                e = new TimeSpanSelectionEvent(this, node, spans);
            }
            ((ILayerContainerSelectionModelListener)listeners[i + 1]).timeSpansAdded(e);
        }
    }

    protected void fireTimeSpansRemoved(Object node, List<ITimeSpan> spans) {
        Object[] listeners = this.listenerList.getListenerList();
        TimeSpanSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ILayerContainerSelectionModelListener.class) continue;
            if (e == null) {
                e = new TimeSpanSelectionEvent(this, node, spans);
            }
            ((ILayerContainerSelectionModelListener)listeners[i + 1]).timeSpansRemoved(e);
        }
    }
}

