/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.swing.layer.ILayerContainerRowHeaderRenderer;
import com.dlsc.flexgantt.swing.layer.LayerContainerRowHeader;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;

public class DefaultLayerContainerRowHeaderRenderer
extends JPanel
implements ILayerContainerRowHeaderRenderer {
    private LayerContainerRowHeader rowHeader;
    private Object node;
    private Object rowHeaderValue;
    private int depth;
    private boolean selected;
    private boolean expanded;
    private boolean leaf;
    private int row;
    private boolean hasFocus;
    private boolean newNode;
    private Color focusForeground = ColorUtil.getFocusForeground();
    private Color focusBackground = ColorUtil.getFocusBackground();
    private boolean paintFocus = true;

    public DefaultLayerContainerRowHeaderRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getRowHeaderRendererComponent(LayerContainerRowHeader header, Object node, Object rowHeaderValue, int depth, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean newNode) {
        this.rowHeader = header;
        this.node = node;
        this.rowHeaderValue = rowHeaderValue;
        this.depth = depth;
        this.selected = selected;
        this.expanded = expanded;
        this.leaf = leaf;
        this.row = row;
        this.hasFocus = hasFocus;
        this.newNode = newNode;
        this.setFont(header.getFont());
        this.setEnabled(header.isEnabled());
        if (hasFocus && this.isPaintingFocus()) {
            this.setForeground(this.focusForeground);
            this.setBackground(this.focusBackground);
        } else {
            this.setForeground(header.getTreeTable().getForeground(row, true));
            this.setBackground(header.getTreeTable().getBackground(row, true));
        }
        return this;
    }

    public void setPaintingFocus(boolean paintFocus) {
        this.paintFocus = paintFocus;
    }

    public boolean isPaintingFocus() {
        return this.paintFocus;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected boolean isLeaf() {
        return this.leaf;
    }

    protected boolean isNewNode() {
        return this.newNode;
    }

    protected Object getNode() {
        return this.node;
    }

    protected int getRow() {
        return this.row;
    }

    protected LayerContainerRowHeader getRowHeader() {
        return this.rowHeader;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected Object getRowHeaderValue() {
        return this.rowHeaderValue;
    }

    public Color getFocusForeground() {
        return this.focusForeground;
    }

    public void setFocusForeground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.focusForeground = color;
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    public void setFocusBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.focusBackground = color;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

