/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.action.layer;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.swing.action.layer.AbstractLayerContainerAction;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.LassoLayer;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.ActionEvent;

public class LassoModeAction
extends AbstractLayerContainerAction {
    private LassoLayer.LassoMode mode;

    public LassoModeAction(LayerContainer lc, LassoLayer.LassoMode mode) {
        super(lc, "");
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be NULL");
        }
        this.mode = mode;
        switch (mode) {
            case SELECT_TIME_SPANS: {
                this.putValue("SmallIcon", IconRegistry.getIcon(IconId.TIME_SPAN_LASSO));
                this.putValue("Name", Messages.getString("LassoModeAction.NAME_TIME_SPAN_SELECTION"));
                this.setToolTipText(Messages.getString("LassoModeAction.TOOLTIP_TIME_SPAN_SELECTION"));
                break;
            }
            case SELECT_TIMELINE_OBJECTS: {
                this.putValue("SmallIcon", IconRegistry.getIcon(IconId.OBJECT_LASSO));
                this.putValue("Name", Messages.getString("LassoModeAction.NAME_OBJECT_SELECTION"));
                this.setToolTipText(Messages.getString("LassoModeAction.TOOLTIP_TIMELINE_OBJECT_SELECTION"));
                break;
            }
            case CREATE_TIMELINE_OBJECTS: {
                this.putValue("SmallIcon", IconRegistry.getIcon(IconId.CREATE_TIMELINE_OBJECT));
                this.putValue("Name", Messages.getString("LassoModeAction.NAME_OBJECT_CREATION"));
                this.setToolTipText(Messages.getString("LassoModeAction.TOOLTIP_CREATE_TIMELINE_OBJECTS"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        LassoLayer ll = this.layerContainer.getSystemLayer(LassoLayer.class);
        ll.setLassoMode(this.mode);
    }

    public LassoLayer.LassoMode getMode() {
        return this.mode;
    }
}

