/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.action.gantt;

import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.treetable.INodeEditPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DualGanttChart;
import com.dlsc.flexgantt.swing.action.gantt.AbstractGanttChartAction;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.SpreadsheetLayer;
import com.dlsc.flexgantt.swing.treetable.CellFocusManager;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class MoveFocusAction<T extends AbstractGanttChart>
extends AbstractGanttChartAction<T> {
    private Direction dir;

    public MoveFocusAction(T gc, Direction dir) {
        super(gc, "");
        this.dir = dir;
        switch (dir) {
            case BELOW: {
                this.putValue("Name", Messages.getString("MoveFocusAction.FOCUS_ON_TABLE_CELL_BELOW"));
                break;
            }
            case ABOVE: {
                this.putValue("Name", Messages.getString("MoveFocusAction.FOCUS_ON_TABLE_CELL_ABOVE"));
                break;
            }
            case PREVIOUS: {
                this.putValue("Name", Messages.getString("MoveFocusAction.FOCUS_ON_PREVIOUS_TABLE_CELL"));
                break;
            }
            case NEXT: {
                this.putValue("Name", Messages.getString("MoveFocusAction.FOCUS_ON_NEXT_TABLE_CELL"));
                break;
            }
            case HOME: {
                this.putValue("Name", Messages.getString("MoveFocusAction.FOCUS_ON_FIRST_TABLE_CELL"));
                break;
            }
            case BOTTOM: {
                this.putValue("Name", Messages.getString("MoveFocusAction.FOCUS_ON_LAST_TABLE_CELL"));
                break;
            }
            case PAGE_UP: {
                this.putValue("Name", Messages.getString("MoveFocusAction.PAGE_UP"));
                break;
            }
            case PAGE_DOWN: {
                this.putValue("Name", Messages.getString("MoveFocusAction.PAGE_DOWN"));
                break;
            }
            case NEXT_TABLE: {
                this.putValue("Name", Messages.getString("MoveFocusAction.NEXT_TABLE"));
                break;
            }
            case PREVIOUS_TABLE: {
                this.putValue("Name", Messages.getString("MoveFocusAction.PREVIOUS_TABLE"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.isSpreadsheetFocusOwner()) {
            this.updateFocusInSpreadsheet();
        } else {
            this.updateFocusInTable();
        }
    }

    private boolean isSpreadsheetFocusOwner() {
        if (this.ganttChart.getActiveSpreadsheet() != null) {
            SpreadsheetLayer layer = this.findFocusedSpreadsheet(this.ganttChart.getLayerContainers());
            return layer != null;
        }
        return false;
    }

    private void updateFocusInSpreadsheet() {
        SpreadsheetLayer layer = this.findFocusedSpreadsheet(this.ganttChart.getLayerContainers());
        switch (this.dir) {
            case BELOW: {
                layer.focusOnCellBelow();
                break;
            }
            case ABOVE: {
                layer.focusOnCellAbove();
                break;
            }
            case PREVIOUS: {
                layer.focusOnCellPrevious();
                break;
            }
            case NEXT: {
                layer.focusOnCellNext();
                break;
            }
            case HOME: {
                layer.focusOnFirstCell();
                break;
            }
            case BOTTOM: {
                layer.focusOnLastCell();
                break;
            }
            case PAGE_UP: {
                layer.focusOnPageUp();
                break;
            }
            case PAGE_DOWN: {
                layer.focusOnPageDown();
                break;
            }
            case NEXT_TABLE: {
                this.nextTable();
                break;
            }
            case PREVIOUS_TABLE: {
                this.previousTable();
            }
        }
    }

    private void updateFocusInTable() {
        TreeTable[] tables = this.ganttChart.getTreeTables();
        TreeTable table = this.findTable(tables);
        CellFocusManager mgr = table.getCellFocusManager();
        if (mgr.hasFocus()) {
            switch (this.dir) {
                case BELOW: {
                    mgr.focusOnCellBelow();
                    break;
                }
                case ABOVE: {
                    mgr.focusOnCellAbove();
                    break;
                }
                case PREVIOUS: {
                    mgr.focusOnCellPrevious();
                    break;
                }
                case NEXT: {
                    mgr.focusOnCellNext();
                    break;
                }
                case HOME: {
                    mgr.focusOnFirstCell();
                    break;
                }
                case BOTTOM: {
                    mgr.focusOnLastCell();
                    break;
                }
                case PAGE_UP: {
                    mgr.focusOnPageUp();
                    break;
                }
                case PAGE_DOWN: {
                    mgr.focusOnPageDown();
                    break;
                }
                case NEXT_TABLE: {
                    this.nextTable();
                    break;
                }
                case PREVIOUS_TABLE: {
                    this.previousTable();
                }
            }
        } else {
            mgr.focusOnFirstVisibleCell();
        }
        TreePath focusedPath = mgr.getFocusedPath();
        if (focusedPath != null) {
            Object node = focusedPath.getLastPathComponent();
            IPolicyProvider pp = table.getPolicyProvider();
            INodeEditPolicy nep = pp.getPolicy(INodeEditPolicy.class);
            if (nep.isSelectable(node, table.getModel())) {
                table.setSelectionPath(focusedPath);
            } else {
                table.clearSelection();
            }
        }
    }

    private void previousTable() {
        TreeTable[] tables = this.ganttChart.getTreeTables();
        int count = tables.length;
        for (int i = 0; i < count; ++i) {
            TreeTable table = tables[i];
            CellFocusManager mgr = table.getCellFocusManager();
            if (!mgr.hasFocus()) continue;
            if (i > 0) {
                this.transferFocus(table, tables[i - 1]);
                break;
            }
            this.transferFocus(table, tables[count - 1]);
            break;
        }
    }

    private void nextTable() {
        TreeTable[] tables = this.ganttChart.getTreeTables();
        int count = tables.length;
        for (int i = 0; i < count; ++i) {
            TreeTable table = tables[i];
            CellFocusManager mgr = table.getCellFocusManager();
            if (!mgr.hasFocus()) continue;
            if (i < count - 1) {
                this.transferFocus(table, tables[i + 1]);
                break;
            }
            this.transferFocus(table, tables[0]);
            break;
        }
    }

    private void transferFocus(TreeTable oldTable, TreeTable newTable) {
        Object gc;
        CellFocusManager oldMgr = oldTable.getCellFocusManager();
        TreeTableColumn focusedColumn = oldMgr.getFocusedColumn();
        oldMgr.looseFocus();
        CellFocusManager newMgr = newTable.getCellFocusManager();
        newMgr.setFocusedColumn(focusedColumn);
        newMgr.focusOnFirstVisibleCell();
        TreePath path = newMgr.getFocusedPath();
        if (path != null) {
            newTable.setSelectionPath(path);
        }
        if ((gc = this.getGanttChart()) instanceof DualGanttChart) {
            ((DualGanttChart)gc).setSecondaryVisible(true);
        }
    }

    private TreeTable findTable(TreeTable[] tables) {
        for (TreeTable table : tables) {
            CellFocusManager mgr = table.getCellFocusManager();
            if (!mgr.hasFocus()) continue;
            return table;
        }
        return tables[0];
    }

    private SpreadsheetLayer findFocusedSpreadsheet(LayerContainer[] layerContainers) {
        for (LayerContainer table : layerContainers) {
            SpreadsheetLayer layer = table.getSystemLayer(SpreadsheetLayer.class);
            if (layer == null || !layer.hasFocus()) continue;
            return layer;
        }
        return null;
    }

    public static enum Direction {
        ABOVE,
        BELOW,
        PREVIOUS,
        NEXT,
        HOME,
        BOTTOM,
        PAGE_DOWN,
        PAGE_UP,
        NEXT_TABLE,
        PREVIOUS_TABLE;

    }
}

