/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GridControlPanel;
import com.dlsc.flexgantt.swing.PagingControlPanel;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.util.CustomizableLineBorder;
import com.dlsc.flexgantt.swing.util.RollOverLabel;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class UtilityControlPanel
extends JPanel
implements LayoutManager,
IGanttChartModelListener,
PropertyChangeListener {
    private GridControlPanel gridControlPanel;
    private PagingControlPanel pagingControlPanel;
    private Selector layerSelector;
    private Selector overviewSelector;
    private Selector spreadsheetSelector;
    private RollOverLabel layerLabel;
    private RollOverLabel overviewLabel;
    private RollOverLabel spreadsheetLabel;
    private AbstractGanttChart ganttChart;

    public UtilityControlPanel(AbstractGanttChart gc) {
        this.ganttChart = gc;
        this.setLayout(this);
        this.gridControlPanel = new GridControlPanel(gc);
        this.add(this.gridControlPanel);
        this.pagingControlPanel = new PagingControlPanel(gc);
        this.add(this.pagingControlPanel);
        this.layerLabel = new RollOverLabel(IconRegistry.getIcon(IconId.LAYER_SELECTOR));
        this.layerLabel.setBorder(new CustomizableLineBorder());
        this.layerLabel.setToolTipText(Messages.getString("UtilityControlPanel.LAYER_CONTROLS"));
        this.add(this.layerLabel);
        this.layerLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    ISelectorFactory sf = UtilityControlPanel.this.ganttChart.getSelectorFactory();
                    if (UtilityControlPanel.this.layerSelector == null) {
                        UtilityControlPanel.this.layerSelector = sf.createSelector(UtilityControlPanel.this.ganttChart, (JComponent)UtilityControlPanel.this.layerLabel, ISelectorFactory.SelectorID.LAYERS);
                    }
                    UtilityControlPanel.this.layerSelector.setVisible(!UtilityControlPanel.this.layerSelector.isVisible());
                }
            }
        });
        this.overviewLabel = new RollOverLabel(IconRegistry.getIcon(IconId.OVERVIEW_SELECTOR));
        this.overviewLabel.setToolTipText(Messages.getString("UtilityControlPanel.OVERVIEW"));
        this.overviewLabel.setBorder(new CustomizableLineBorder());
        this.add(this.overviewLabel);
        this.overviewLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    ISelectorFactory sf = UtilityControlPanel.this.ganttChart.getSelectorFactory();
                    if (UtilityControlPanel.this.overviewSelector == null) {
                        UtilityControlPanel.this.overviewSelector = sf.createSelector(UtilityControlPanel.this.ganttChart, (JComponent)UtilityControlPanel.this.overviewLabel, ISelectorFactory.SelectorID.OVERVIEW);
                    }
                    UtilityControlPanel.this.overviewSelector.setVisible(!UtilityControlPanel.this.overviewSelector.isVisible());
                }
            }
        });
        this.spreadsheetLabel = new RollOverLabel(IconRegistry.getIcon(IconId.SPREADSHEET_SELECTOR));
        this.spreadsheetLabel.setToolTipText(Messages.getString("UtilityControlPanel.SPREADSHEETS"));
        this.spreadsheetLabel.setBorder(new CustomizableLineBorder());
        this.add(this.spreadsheetLabel);
        this.spreadsheetLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    ISelectorFactory sf = UtilityControlPanel.this.ganttChart.getSelectorFactory();
                    if (UtilityControlPanel.this.spreadsheetSelector == null) {
                        UtilityControlPanel.this.spreadsheetSelector = sf.createSelector(UtilityControlPanel.this.ganttChart, (JComponent)UtilityControlPanel.this.spreadsheetLabel, ISelectorFactory.SelectorID.SPREADSHEET);
                    }
                    UtilityControlPanel.this.spreadsheetSelector.setVisible(!UtilityControlPanel.this.spreadsheetSelector.isVisible());
                }
            }
        });
        for (Component control : this.getComponents()) {
            control.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("visible")) {
                        UtilityControlPanel.this.invalidate();
                        UtilityControlPanel.this.validate();
                    }
                }
            });
        }
        this.ganttChart.addPropertyChangeListener(this);
        this.ganttChart.getModel().addGanttChartModelListener(this);
        this.updateSpreadsheetSelectorLabel();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int x = insets.left;
        int y = insets.top;
        int h = parent.getHeight() - insets.top - insets.bottom;
        for (Component comp : this.getComponents()) {
            if (!comp.isVisible()) continue;
            Dimension dim = comp.getPreferredSize();
            comp.setBounds(x, y, dim.width, h);
            x += dim.width;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        for (Component comp : this.getComponents()) {
            if (!comp.isVisible()) continue;
            Dimension ps = comp.getPreferredSize();
            width += ps.width;
            height = Math.max(height, ps.height);
        }
        Dimension dim = new Dimension(width, height);
        Insets insets = parent.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public GridControlPanel getGridControlPanel() {
        return this.gridControlPanel;
    }

    public PagingControlPanel getPagingControlPanel() {
        return this.pagingControlPanel;
    }

    public RollOverLabel getLayerLabel() {
        return this.layerLabel;
    }

    public RollOverLabel getOverviewLabel() {
        return this.overviewLabel;
    }

    public RollOverLabel getSpreadsheetLabel() {
        return this.spreadsheetLabel;
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    @Override
    public void ganttChartChanged(GanttChartModelEvent evt) {
        if (evt.getSource().equals(this.ganttChart.getModel())) {
            switch (evt.getId()) {
                case SPREADSHEET_ADDED: 
                case SPREADSHEET_REMOVED: {
                    this.updateSpreadsheetSelectorLabel();
                    break;
                }
            }
        }
    }

    private void updateSpreadsheetSelectorLabel() {
        boolean hasSpreadsheets = this.ganttChart.getModel().getSpreadsheets().hasNext();
        this.spreadsheetLabel.setVisible(hasSpreadsheets);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.ganttChart) && evt.getPropertyName().equals("model")) {
            IGanttChartModel oldModel = (IGanttChartModel)evt.getOldValue();
            IGanttChartModel newModel = (IGanttChartModel)evt.getNewValue();
            if (oldModel != null) {
                oldModel.removeGanttChartModelListener(this);
            }
            if (newModel != null) {
                newModel.addGanttChartModelListener(this);
            }
            this.updateSpreadsheetSelectorLabel();
        }
    }
}

