/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.TimeZonePanel;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimeZoneDialog
extends JDialog {
    private TimeZonePanel timeZonePanel;
    private TimeZone selectedTimeZone;
    private JTextField textField;
    private JButton okButton;
    private JButton cancelButton;

    public TimeZoneDialog() {
        this.init();
    }

    public TimeZoneDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public TimeZoneDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public TimeZoneDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public TimeZoneDialog(Dialog owner, String title) {
        super(owner, title);
        this.init();
    }

    public TimeZoneDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public TimeZoneDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public TimeZoneDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
    }

    public TimeZoneDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init();
    }

    public TimeZoneDialog(Frame owner, String title) {
        super(owner, title);
        this.init();
    }

    public TimeZoneDialog(Frame owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TimeZoneDialog.this.cancelPressed();
            }
        });
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(10, 10));
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.textField = new JTextField();
        this.textField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                TimeZoneDialog.this.timeZonePanel.setFilter(TimeZoneDialog.this.textField.getText());
            }
        });
        content.add("North", this.textField);
        this.timeZonePanel = new TimeZonePanel();
        this.timeZonePanel.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TimeZoneDialog.this.okPressed();
                }
            }
        });
        this.timeZonePanel.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TimeZoneDialog.this.timeZonePanel.getList().getSelectedValue() != null) {
                    TimeZoneDialog.this.okButton.setEnabled(true);
                } else {
                    TimeZoneDialog.this.okButton.setEnabled(false);
                }
            }
        });
        content.add("Center", this.timeZonePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(Messages.getString("TimeZoneDialog.OK_BUTTON"));
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(Messages.getString("TimeZoneDialog.CANCEL_BUTTON"));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeZoneDialog.this.okPressed();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeZoneDialog.this.cancelPressed();
            }
        });
        content.add("South", buttonPanel);
        this.add("Center", content);
        this.pack();
    }

    protected void okPressed() {
        this.selectedTimeZone = this.timeZonePanel.getSelectedTimeZone();
        this.setVisible(false);
    }

    protected void cancelPressed() {
        this.selectedTimeZone = null;
        this.setVisible(false);
    }

    public TimeZone getSelectedTimeZone() {
        return this.selectedTimeZone;
    }

    public TimeZonePanel getTimeZonePanel() {
        return this.timeZonePanel;
    }

    public void setSelectedTimeZone(TimeZone zone) {
        this.timeZonePanel.setSelectedTimeZone(zone);
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

