/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.util.WindowsCornerIcon;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class StatusBar
extends JPanel
implements LayoutManager {
    private static final Logger LOGGER = Logger.getLogger(StatusBar.class.getName());
    private JLabel statusLabel = new JLabel(Messages.getString("StatusBar.DEFAULT_TEXT"));
    private JPanel itemPanel = new JPanel();
    private JLabel resizeIconLabel = new JLabel(new WindowsCornerIcon());
    private boolean separatorsVisible = true;

    public StatusBar(boolean separatorsVisible) {
        this.separatorsVisible = separatorsVisible;
        this.setLayout(this);
        this.setPreferredSize(new Dimension(10, 23));
        this.setName("StatusBar");
        this.statusLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.resizeIconLabel.setVerticalAlignment(3);
        GridBagLayout gl = new GridBagLayout();
        this.itemPanel = new JPanel(new BorderLayout());
        this.itemPanel.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.itemPanel.setLayout(gl);
        this.itemPanel.setOpaque(false);
        this.add(this.resizeIconLabel);
        this.add(this.itemPanel);
        this.add(this.statusLabel);
    }

    public StatusBar() {
        this(true);
    }

    public void setStatus(String status) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting status to: " + status);
        }
        if (status != null) {
            this.statusLabel.setText(status);
        } else {
            this.statusLabel.setText("");
        }
    }

    public String getStatus() {
        return this.statusLabel.getText();
    }

    public void addItem(JComponent item) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.itemPanel.add((Component)item, gbc);
    }

    public void removeAllItems() {
        this.itemPanel.removeAll();
    }

    public void addSeparator() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 5, 0, 5);
        JSeparator sep = new JSeparator(1);
        sep.setVisible(this.separatorsVisible);
        this.itemPanel.add((Component)sep, gbc);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (UIManager.getLookAndFeel().getName().toLowerCase().contains("windows")) {
            int y = 0;
            g.setColor(new Color(156, 154, 140));
            g.drawLine(0, y, this.getWidth(), y);
            g.setColor(new Color(196, 194, 183));
            g.drawLine(0, ++y, this.getWidth(), y);
            g.setColor(new Color(218, 215, 201));
            g.drawLine(0, ++y, this.getWidth(), y);
            g.setColor(new Color(233, 231, 217));
            g.drawLine(0, ++y, this.getWidth(), y);
            y = this.getHeight() - 3;
            g.setColor(new Color(233, 232, 218));
            g.drawLine(0, y, this.getWidth(), y);
            g.setColor(new Color(233, 231, 216));
            g.drawLine(0, ++y, this.getWidth(), y);
            y = this.getHeight() - 1;
            g.setColor(new Color(221, 221, 220));
            g.drawLine(0, y, this.getWidth(), y);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        int width = 0;
        int height = 0;
        for (Component comp : target.getComponents()) {
            Dimension dim = comp.getPreferredSize();
            width += dim.width;
            height = Math.max(height, dim.height);
        }
        Insets insets = target.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom + 6);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int w = target.getWidth() - insets.left - insets.right;
        int h = target.getHeight() - insets.top - insets.bottom;
        Dimension dim = this.resizeIconLabel.getPreferredSize();
        this.resizeIconLabel.setBounds(w - dim.width, h - dim.height, dim.width, dim.height);
        dim = this.itemPanel.getPreferredSize();
        this.itemPanel.setBounds((w -= dim.width) - dim.width, 4, dim.width, h - 4);
        this.statusLabel.setBounds(0, 4, w -= dim.width, h - 4);
    }

    public JPanel getItemPanel() {
        return this.itemPanel;
    }

    public JLabel getResizeIconLabel() {
        return this.resizeIconLabel;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }
}

