/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.swing.IRelationshipMessage;
import com.dlsc.flexgantt.swing.Message;
import com.dlsc.flexgantt.swing.MessageTypeId;
import java.util.Calendar;
import java.util.Date;

public class RelationshipMessage
extends Message
implements IRelationshipMessage {
    private IRelationship relationship;

    public RelationshipMessage(MessageTypeId id, String text, Object details, Date time, IRelationship relationship) {
        super(id, text, details, time);
        if (relationship == null) {
            throw new IllegalArgumentException("relationship object can not be NULL");
        }
        this.relationship = relationship;
    }

    public RelationshipMessage(MessageTypeId id, String text, Date time, IRelationship relationship) {
        this(id, text, null, time, relationship);
    }

    public RelationshipMessage(MessageTypeId id, String text, Object details, IRelationship relationship) {
        this(id, text, details, Calendar.getInstance().getTime(), relationship);
    }

    public RelationshipMessage(MessageTypeId id, String text, IRelationship relationship) {
        this(id, text, null, Calendar.getInstance().getTime(), relationship);
    }

    public RelationshipMessage(String text, Object details, IRelationship relationship) {
        this(MessageTypeId.INFORMATION, text, details, Calendar.getInstance().getTime(), relationship);
    }

    public RelationshipMessage(String text, IRelationship relationship) {
        this(MessageTypeId.INFORMATION, text, null, Calendar.getInstance().getTime(), relationship);
    }

    @Override
    public IRelationship getRelationship() {
        return this.relationship;
    }
}

