/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DualGanttChart;
import com.dlsc.flexgantt.swing.IMultiGanttChartContainer;
import com.dlsc.flexgantt.swing.IMultiGanttChartContainerListener;
import com.dlsc.flexgantt.swing.MultiGanttChartContainerEvent;
import com.dlsc.flexgantt.swing.action.dateline.ZoomInAction;
import com.dlsc.flexgantt.swing.action.dateline.ZoomOutAction;
import com.dlsc.flexgantt.swing.action.gantt.AlignEndTimesAction;
import com.dlsc.flexgantt.swing.action.gantt.AlignStartTimesAction;
import com.dlsc.flexgantt.swing.action.gantt.AllObjectsAction;
import com.dlsc.flexgantt.swing.action.gantt.ClearPinnedPopupsAction;
import com.dlsc.flexgantt.swing.action.gantt.CollapseAllAction;
import com.dlsc.flexgantt.swing.action.gantt.CrosshairAction;
import com.dlsc.flexgantt.swing.action.gantt.EarliestObjectsAction;
import com.dlsc.flexgantt.swing.action.gantt.ExpandAllAction;
import com.dlsc.flexgantt.swing.action.gantt.GridAction;
import com.dlsc.flexgantt.swing.action.gantt.LatestObjectsAction;
import com.dlsc.flexgantt.swing.action.gantt.PopupAction;
import com.dlsc.flexgantt.swing.action.gantt.PreviewGanttChartAction;
import com.dlsc.flexgantt.swing.action.gantt.PrintGanttChartAction;
import com.dlsc.flexgantt.swing.action.gantt.RedoAction;
import com.dlsc.flexgantt.swing.action.gantt.RelationshipsAction;
import com.dlsc.flexgantt.swing.action.gantt.SplitGanttChartAction;
import com.dlsc.flexgantt.swing.action.gantt.TimeNowAction;
import com.dlsc.flexgantt.swing.action.gantt.UndoAction;
import com.dlsc.flexgantt.swing.action.timeline.EventlineAction;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class GanttChartToolBar<T extends AbstractGanttChart>
extends JToolBar
implements PropertyChangeListener,
IMultiGanttChartContainerListener {
    private T ganttChart;
    private Map<Control, AbstractButton> controlButtonMap = new HashMap<Control, AbstractButton>();
    private Mode mode = Mode.ICONS_ONLY;
    private JPopupMenu popup;
    private Timeline timeline;
    private Collection<Control> controls;

    public GanttChartToolBar(String title, int orientation, T ganttChart, Collection<Control> controls) {
        super(title, orientation);
        this.update(title, orientation, ganttChart, controls);
    }

    public GanttChartToolBar(String title, int orientation, T ganttChart) {
        this(title, orientation, ganttChart, null);
    }

    public GanttChartToolBar(String title, T ganttChart) {
        this(title, 0, ganttChart);
    }

    public GanttChartToolBar(int orientation, T ganttChart) {
        this(null, orientation, ganttChart);
    }

    public GanttChartToolBar(T ganttChart) {
        this(null, 0, ganttChart);
    }

    public GanttChartToolBar(String title, int orientation, IMultiGanttChartContainer<T> container, Collection<Control> controls) {
        super(title, orientation);
        if (container == null) {
            throw new IllegalArgumentException("container can not be NULL");
        }
        container.addMultiGanttChartContainerListener(this);
        T ganttChart = container.getSelectedGanttChart();
        if (ganttChart != null) {
            this.update(title, orientation, ganttChart, controls);
        }
    }

    public GanttChartToolBar(String title, int orientation, IMultiGanttChartContainer<T> container) {
        this(title, orientation, container, (Collection<Control>)null);
    }

    public GanttChartToolBar(String title, IMultiGanttChartContainer<T> container) {
        this(title, 0, container);
    }

    public GanttChartToolBar(int orientation, IMultiGanttChartContainer<T> container) {
        this((String)null, orientation, container);
    }

    public GanttChartToolBar(IMultiGanttChartContainer<T> container) {
        this(0, container);
    }

    private void update(T ganttChart) {
        this.update(this.getName(), this.getOrientation(), ganttChart, this.controls);
    }

    private void update(String title, int orientation, T ganttChart, Collection<Control> controls) {
        this.setName(title);
        if (ganttChart == null) {
            throw new IllegalArgumentException("gantt chart can not be NULL");
        }
        this.controls = controls;
        if (this.controls == null) {
            this.controls = new ArrayList<Control>();
            this.controls.addAll(Arrays.asList(Control.values()));
        }
        this.ganttChart = ganttChart;
        ((Container)this.ganttChart).addPropertyChangeListener(this);
        this.timeline = ((AbstractGanttChart)ganttChart).getTimeline();
        this.timeline.getEventline().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                GanttChartToolBar.this.updateToolBar();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                GanttChartToolBar.this.updateToolBar();
            }
        });
        this.setMode(this.mode);
        this.popup = new JPopupMenu(Messages.getString("GanttChartToolBar.POPUP_TITLE"));
        JMenuItem iconOnlyItem = new JMenuItem(Messages.getString("GanttChartToolBar.MENU_ITEM_ICON_ONLY"));
        JMenuItem textOnlyItem = new JMenuItem(Messages.getString("GanttChartToolBar.MENU_ITEM_TEXT_ONLY"));
        JMenuItem iconAndTextItem = new JMenuItem(Messages.getString("GanttChartToolBar.MENU_ITEM_ICON_AND_TEXT"));
        this.popup.add(iconOnlyItem);
        this.popup.add(textOnlyItem);
        this.popup.add(iconAndTextItem);
        iconOnlyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GanttChartToolBar.this.setMode(Mode.ICONS_ONLY);
            }
        });
        textOnlyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GanttChartToolBar.this.setMode(Mode.TEXT_ONLY);
            }
        });
        iconAndTextItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GanttChartToolBar.this.setMode(Mode.ICONS_AND_TEXT);
            }
        });
        this.setComponentPopupMenu(this.popup);
    }

    public void setMode(Mode mode) {
        Action[] actions;
        this.mode = mode;
        this.removeAll();
        boolean separator = false;
        if (this.controls.contains((Object)Control.UNDO)) {
            this.controlButtonMap.put(Control.UNDO, this.addButton(new UndoAction<T>(this.ganttChart)));
            separator = true;
        }
        if (this.controls.contains((Object)Control.REDO)) {
            this.controlButtonMap.put(Control.REDO, this.addButton(new RedoAction<T>(this.ganttChart)));
            separator = true;
        }
        if (separator) {
            this.addSeparator();
        }
        separator = false;
        if (this.controls.contains((Object)Control.PRINT)) {
            this.controlButtonMap.put(Control.PRINT, this.addButton(new PrintGanttChartAction<T>(this.ganttChart)));
            separator = true;
        }
        if (this.controls.contains((Object)Control.PRINT_PREVIEW)) {
            this.controlButtonMap.put(Control.PRINT_PREVIEW, this.addButton(new PreviewGanttChartAction<T>(this.ganttChart)));
            separator = true;
        }
        if (separator) {
            this.addSeparator();
        }
        separator = false;
        if (this.controls.contains((Object)Control.TREE_EXPAND_ALL)) {
            this.controlButtonMap.put(Control.TREE_EXPAND_ALL, this.addButton(new ExpandAllAction<T>(this.ganttChart)));
            separator = true;
        }
        if (this.controls.contains((Object)Control.TREE_COLLAPSE_ALL)) {
            this.controlButtonMap.put(Control.TREE_COLLAPSE_ALL, this.addButton(new CollapseAllAction<T>(this.ganttChart)));
            separator = true;
        }
        if (separator) {
            this.addSeparator();
        }
        separator = false;
        if (this.controls.contains((Object)Control.ZOOM_IN)) {
            this.controlButtonMap.put(Control.ZOOM_IN, this.addButton(new ZoomInAction(((AbstractGanttChart)this.ganttChart).getDateline())));
            separator = true;
        }
        if (this.controls.contains((Object)Control.ZOOM_OUT)) {
            this.controlButtonMap.put(Control.ZOOM_OUT, this.addButton(new ZoomOutAction(((AbstractGanttChart)this.ganttChart).getDateline())));
            separator = true;
        }
        if (this.controls.contains((Object)Control.SHOW_ALL)) {
            this.controlButtonMap.put(Control.SHOW_ALL, this.addButton(new AllObjectsAction<T>(this.ganttChart)));
            separator = true;
        }
        if (this.controls.contains((Object)Control.TIME_NOW)) {
            this.controlButtonMap.put(Control.TIME_NOW, this.addButton(new TimeNowAction<T>(this.ganttChart)));
            separator = true;
        }
        if (this.controls.contains((Object)Control.EARLIEST_OBJECTS)) {
            this.controlButtonMap.put(Control.EARLIEST_OBJECTS, this.addButton(new EarliestObjectsAction<T>(this.ganttChart)));
            separator = true;
        }
        if (this.controls.contains((Object)Control.LATEST_OBJECTS)) {
            this.controlButtonMap.put(Control.EARLIEST_OBJECTS, this.addButton(new LatestObjectsAction<T>(this.ganttChart)));
            separator = true;
        }
        if (separator) {
            this.addSeparator();
        }
        separator = false;
        if (this.controls.contains((Object)Control.ALIGN_START_TIMES)) {
            this.controlButtonMap.put(Control.ALIGN_START_TIMES, this.addButton(new AlignStartTimesAction<T>(this.ganttChart)));
            separator = true;
        }
        if (this.controls.contains((Object)Control.ALIGN_END_TIMES)) {
            this.controlButtonMap.put(Control.ALIGN_END_TIMES, this.addButton(new AlignEndTimesAction<T>(this.ganttChart)));
            separator = true;
        }
        if (separator) {
            this.addSeparator();
        }
        separator = false;
        if (this.controls.contains((Object)Control.GRID)) {
            this.controlButtonMap.put(Control.GRID, this.addButton(new GridAction<T>(this.ganttChart)));
        }
        if (this.controls.contains((Object)Control.POPUP)) {
            this.controlButtonMap.put(Control.POPUP, this.addButton(new PopupAction<T>(this.ganttChart), true));
        }
        if (this.controls.contains((Object)Control.POPUP_CLEAR)) {
            this.controlButtonMap.put(Control.POPUP_CLEAR, this.addButton(new ClearPinnedPopupsAction<T>(this.ganttChart)));
        }
        if (this.controls.contains((Object)Control.EVENTLINE)) {
            this.controlButtonMap.put(Control.EVENTLINE, this.addButton(new EventlineAction(((AbstractGanttChart)this.ganttChart).getTimeline()), true));
        }
        if (this.controls.contains((Object)Control.CROSSHAIR)) {
            this.controlButtonMap.put(Control.CROSSHAIR, this.addButton(new CrosshairAction<T>(this.ganttChart), true));
        }
        if (this.controls.contains((Object)Control.RELATIONS)) {
            this.controlButtonMap.put(Control.RELATIONS, this.addButton(new RelationshipsAction<T>(this.ganttChart), true));
        }
        if (this.controls.contains((Object)Control.SPLIT) && this.ganttChart instanceof DualGanttChart) {
            this.controlButtonMap.put(Control.SPLIT, this.addButton(new SplitGanttChartAction<DualGanttChart>((DualGanttChart)this.ganttChart), true));
        }
        if ((actions = ((AbstractGanttChart)this.ganttChart).getToolBarActions()) != null && actions.length > 0) {
            this.addSeparator();
            for (Action a : actions) {
                this.addButton(a);
            }
        }
        this.updateToolBar();
    }

    public Mode getMode() {
        return this.mode;
    }

    public T getGanttChart() {
        return this.ganttChart;
    }

    private AbstractButton addButton(Action action) {
        return this.addButton(action, false);
    }

    private AbstractButton addButton(Action action, boolean toggle) {
        AbstractButton button = null;
        button = toggle ? new JToggleButton(action) : new JButton(action);
        button.setName(action.getClass().getName());
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setFocusable(false);
        if (this.mode.equals((Object)Mode.TEXT_ONLY)) {
            button.setIcon(null);
        } else if (this.mode.equals((Object)Mode.ICONS_ONLY) && action.getValue("SmallIcon") != null) {
            button.setText("");
        }
        this.add(button);
        return button;
    }

    private void updateToolBar() {
        if (this.controlButtonMap.get((Object)Control.POPUP) != null) {
            this.controlButtonMap.get((Object)Control.POPUP).setSelected(((AbstractGanttChart)this.ganttChart).isPopupVisible());
        }
        if (this.controlButtonMap.get((Object)Control.EVENTLINE) != null) {
            this.controlButtonMap.get((Object)Control.EVENTLINE).setSelected(this.timeline.getEventline().isVisible());
        }
        if (this.controlButtonMap.get((Object)Control.CROSSHAIR) != null) {
            this.controlButtonMap.get((Object)Control.CROSSHAIR).setSelected(((AbstractGanttChart)this.ganttChart).isCrosshairVisible());
        }
        if (this.controlButtonMap.get((Object)Control.RELATIONS) != null) {
            this.controlButtonMap.get((Object)Control.RELATIONS).setSelected(((AbstractGanttChart)this.ganttChart).isRelationsVisible());
        }
        if (this.ganttChart instanceof DualGanttChart && this.controlButtonMap.get((Object)Control.SPLIT) != null) {
            this.controlButtonMap.get((Object)Control.SPLIT).setSelected(((DualGanttChart)this.ganttChart).isSecondaryVisible());
        }
    }

    public AbstractButton getButton(Control control) {
        return this.controlButtonMap.get((Object)control);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.ganttChart)) {
            if (evt.getPropertyName().equals("secondaryVisible")) {
                this.updateToolBar();
            } else if (evt.getPropertyName().equals("popupVisible")) {
                this.updateToolBar();
            } else if (evt.getPropertyName().equals("gridLineMode")) {
                this.updateToolBar();
            } else if (evt.getPropertyName().equals("crosshairVisible")) {
                this.updateToolBar();
            } else if (evt.getPropertyName().equals("relationsVisible")) {
                this.updateToolBar();
            }
        }
    }

    @Override
    public void containerChanged(MultiGanttChartContainerEvent evt) {
        switch (evt.getId()) {
            case GANTT_CHART_CHANGED: {
                this.update(evt.getGanttChart());
                break;
            }
        }
    }

    public static enum Control {
        UNDO(UndoAction.class),
        REDO(RedoAction.class),
        PRINT(PrintGanttChartAction.class),
        PRINT_PREVIEW(PreviewGanttChartAction.class),
        TREE_COLLAPSE_ALL(CollapseAllAction.class),
        TREE_EXPAND_ALL(ExpandAllAction.class),
        ZOOM_IN(ZoomInAction.class),
        ZOOM_OUT(ZoomOutAction.class),
        SHOW_ALL(AllObjectsAction.class),
        TIME_NOW(TimeNowAction.class),
        EARLIEST_OBJECTS(EarliestObjectsAction.class),
        LATEST_OBJECTS(LatestObjectsAction.class),
        ALIGN_START_TIMES(AlignStartTimesAction.class),
        ALIGN_END_TIMES(AlignEndTimesAction.class),
        GRID(GridAction.class),
        POPUP(PopupAction.class),
        POPUP_CLEAR(ClearPinnedPopupsAction.class),
        EVENTLINE(EventlineAction.class),
        CROSSHAIR(CrosshairAction.class),
        RELATIONS(RelationshipsAction.class),
        SPLIT(SplitGanttChartAction.class);

        private Class<? extends Action> actionClass;

        private Control(Class<? extends Action> actionClass) {
            this.actionClass = actionClass;
        }

        public Class<? extends Action> getActionClass() {
            return this.actionClass;
        }
    }

    public static enum Mode {
        ICONS_ONLY,
        TEXT_ONLY,
        ICONS_AND_TEXT;

    }
}

