/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.DefaultColumnModel;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DefaultComponentFactory;
import com.dlsc.flexgantt.swing.GanttChartActionMap;
import com.dlsc.flexgantt.swing.GanttChartInputMap;
import com.dlsc.flexgantt.swing.IComponentFactory;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerRowHeader;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.print.IPrintManager;
import com.dlsc.flexgantt.swing.print.PrintContext;
import com.dlsc.flexgantt.swing.print.PrintGanttChart;
import com.dlsc.flexgantt.swing.print.TimeGranularityPrintManager;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableScrollPane;
import com.dlsc.flexgantt.util.FlexGanttLicenseManager;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class GanttChart
extends AbstractGanttChart {
    private static final Logger LOGGER = Logger.getLogger(GanttChart.class.getName());
    public static final String PROPERTY_PRINT_MANAGER = "printManager";
    private TreeTable treeTable;
    private LayerContainer layerContainer;
    private LayerContainerRowHeader layerContainerRowHeader;
    private JSplitPane splitPane;
    private TreeTableScrollPane treeTableScrollPane;
    private TreeTableRowHeader treeTableRowHeader;
    private LayerContainerScrollPane layerContainerScrollPane;
    private IPrintManager printManager = new TimeGranularityPrintManager();
    private PrintContext printContext;

    public GanttChart(IGanttChartModel model, IColumnModel columnModel, TimeZone zone, IComponentFactory compFactory) {
        super(model, columnModel, compFactory);
        this.setLayout(new BorderLayout());
        this.setName("GanttChart");
        Timeline timeline = this.getTimeline();
        TreeTableHeader treeTableHeader = this.getTreeTableHeader();
        IComponentFactory factory = this.getComponentFactory();
        this.treeTable = factory.createTreeTable(this, model);
        this.treeTable.setName("TreeTable");
        this.layerContainer = factory.createLayerContainer(this, this.treeTable, model);
        this.layerContainer.setName("LayerContainer");
        this.layerContainerRowHeader = factory.createLayerContainerRowHeader(this.layerContainer);
        this.layerContainerRowHeader.setName("LayerContainerRowHeader");
        this.treeTableRowHeader = factory.createTreeTableRowHeader(this.treeTable);
        this.treeTableRowHeader.setName("TreeTableRowHeader");
        this.treeTableScrollPane = factory.createTreeTableScrollPane(this.treeTable, this.treeTableRowHeader, treeTableHeader, true);
        this.treeTableScrollPane.setName("TreeTableScrollPane");
        this.layerContainerScrollPane = factory.createLayerContainerScrollPane(this.layerContainer, this.layerContainerRowHeader, timeline, true);
        this.layerContainerScrollPane.setName("LayerContainerScrollPane");
        this.layerContainerScrollPane.setVerticalScrollBar(this.treeTableScrollPane.getVerticalScrollBar());
        this.splitPane = factory.createSplitPane();
        this.splitPane.setName("SplitPane");
        this.splitPane.setLeftComponent(this.treeTableScrollPane);
        this.splitPane.setRightComponent(this.layerContainerScrollPane);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(false);
        final AbstractGanttChart.Banner banner = new AbstractGanttChart.Banner(this);
        banner.setVisible(false);
        this.add("North", banner);
        if (FlexGanttLicenseManager.isDevelopmentLicense()) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            1.sleep(14400000L);
                        }
                        catch (InterruptedException ex) {
                            LOGGER.throwing(AbstractGanttChart.class.getName(), "Thread.run()", ex);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                banner.setVisible(true);
                            }
                        });
                    }
                }
            };
            thread.setName("GanttChartDevelopmentLicenseThread");
            thread.setDaemon(true);
            thread.start();
        }
        this.add("Center", this.splitPane);
        this.resetToPreferredSizes();
        this.setActionMap(new GanttChartActionMap<GanttChart>(this));
        this.setInputMap(0, new GanttChartInputMap<GanttChart>(this));
    }

    public GanttChart(IGanttChartModel model, IColumnModel columnModel, IComponentFactory compFactory) {
        this(model, columnModel, TimeZone.getDefault(), compFactory);
    }

    public GanttChart(IGanttChartModel model, IColumnModel columnModel) {
        this(model, columnModel, DefaultComponentFactory.getInstance());
    }

    public GanttChart(IGanttChartModel model, IComponentFactory compFactory) {
        this(model, new DefaultColumnModel(), compFactory);
    }

    public GanttChart(IGanttChartModel model) {
        this(model, new DefaultColumnModel());
    }

    public GanttChart(IColumnModel columnModel) {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()), columnModel);
    }

    public GanttChart(IComponentFactory compFactory) {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()), compFactory);
    }

    public GanttChart() {
        this(new DefaultGanttChartModel(new DefaultGanttChartNode()));
    }

    public LayerContainer getLayerContainer() {
        return this.layerContainer;
    }

    public LayerContainerRowHeader getLayerContainerRowHeader() {
        return this.layerContainerRowHeader;
    }

    public TreeTable getTreeTable() {
        return this.treeTable;
    }

    @Override
    public TreeTable[] getTreeTables() {
        return new TreeTable[]{this.treeTable};
    }

    public LayerContainerScrollPane getLayerContainerScrollPane() {
        return this.layerContainerScrollPane;
    }

    @Override
    public LayerContainer[] getLayerContainers() {
        return new LayerContainer[]{this.layerContainer};
    }

    public TreeTableRowHeader getTreeTableRowHeader() {
        return this.treeTableRowHeader;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public TreeTableScrollPane getTreeTableScrollPane() {
        return this.treeTableScrollPane;
    }

    @Override
    public void resetToPreferredSizes() {
        this.splitPane.setDividerLocation(this.treeTableScrollPane.getPreferredSize().width + 1);
    }

    public IPrintManager getPrintManager() {
        return this.printManager;
    }

    public void setPrintManager(IPrintManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("print manager can not be NULL");
        }
        IPrintManager oldManager = this.printManager;
        this.printManager = manager;
        this.firePropertyChange(PROPERTY_PRINT_MANAGER, oldManager, this.printManager);
    }

    @Override
    public void setModel(IGanttChartModel model) {
        super.setModel(model);
        if (this.treeTable != null) {
            this.treeTable.setModel(model);
            this.layerContainer.setModel(model);
        }
    }

    @Override
    public PrintContext[] getPrintContexts() {
        if (this.printContext == null) {
            this.printContext = new PrintContext();
            this.printContext.setGanttChart(this);
            this.printContext.setLayerContainer(this.layerContainer);
            this.printContext.setTreeTable(this.treeTable);
            this.printContext.setTreeTableHeader(this.getTreeTableHeader());
            this.printContext.setRowHeader(this.treeTableRowHeader);
            this.printContext.setTimeline(this.getTimeline());
            this.printContext.setTimeSpan(this.getTimeSpan());
            this.printContext.setPrintSetup(this.getPrintSetup());
        }
        return new PrintContext[]{this.printContext};
    }

    @Override
    public void print(boolean preview) {
        if (this.printContext != null) {
            this.print(preview, this.printContext.getTimeSpan());
        } else {
            super.print(preview);
        }
    }

    @Override
    public void print(boolean preview, ITimeSpan span) {
        if (this.printContext == null) {
            this.printContext = new PrintContext();
            this.printContext.setGanttChart(this);
            this.printContext.setLayerContainer(this.layerContainer);
            this.printContext.setTreeTable(this.treeTable);
            this.printContext.setTreeTableHeader(this.getTreeTableHeader());
            this.printContext.setRowHeader(this.treeTableRowHeader);
            this.printContext.setTimeline(this.getTimeline());
            this.printContext.setPrintSetup(this.getPrintSetup());
        }
        this.printContext.setTimeSpan(span);
        try {
            this.printManager.print(this, this.printContext, preview);
        }
        catch (Exception ex) {
            LOGGER.throwing(this.getClass().getName(), "print()", ex);
            this.showMessage(Messages.getString("GanttChart.PRINT_REQUEST_FAILED"), MessageTypeId.ERROR, ex);
        }
    }

    @Override
    public LayerContainerScrollPane[] getLayerContainerScrollPanes() {
        return new LayerContainerScrollPane[]{this.layerContainerScrollPane};
    }

    @Override
    public TreeTableScrollPane[] getTreeTableScrollPanes() {
        return new TreeTableScrollPane[]{this.treeTableScrollPane};
    }

    @Override
    public IGridComponent[] getGridComponents() {
        return new IGridComponent[]{this.layerContainer, this.getEventline()};
    }

    @Override
    public void tearDown() {
        PrintGanttChart gc;
        IPrintManager mgr = this.getPrintManager();
        if (mgr != null && (gc = mgr.getPrintGanttChart()) != null) {
            gc.tearDown();
        }
        super.tearDown();
    }
}

