/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.treetable.ColumnModelEvent;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.model.treetable.IColumnModelListener;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColumnChooser
extends JPanel
implements IColumnModelListener,
PropertyChangeListener {
    private JList availableList;
    private JList usedList;
    private AbstractGanttChart ganttChart;
    private JButton upButton;
    private JButton downButton;
    private JButton removeButton;
    private JButton addButton;
    private JScrollPane availableListScrollPane;
    private JScrollPane usedListScrollPane;

    public ColumnChooser(AbstractGanttChart gc) {
        this.ganttChart = gc;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel availablePanel = new JPanel();
        JPanel usedPanel = new JPanel();
        availablePanel.setOpaque(false);
        availablePanel.setBorder(this.createTitledBorder(Messages.getString("ColumnChooser.LIST_AVAILABLE_COLUMNS")));
        usedPanel.setOpaque(false);
        usedPanel.setBorder(this.createTitledBorder(Messages.getString("ColumnChooser.LIST_USED_COLUMNS")));
        availablePanel.setLayout(new BorderLayout());
        usedPanel.setLayout(new BorderLayout());
        this.availableList = new JList(new DefaultListModel());
        this.availableList.setVisibleRowCount(10);
        this.availableList.setPrototypeCellValue("Prototype Column Name");
        this.availableList.setCellRenderer(new ColumnListCellRenderer());
        this.usedList = new JList(new DefaultListModel());
        this.usedList.setPrototypeCellValue("Prototype Column Name");
        this.usedList.setVisibleRowCount(10);
        this.usedList.setCellRenderer(new ColumnListCellRenderer());
        this.availableListScrollPane = new JScrollPane(this.availableList);
        this.availableListScrollPane.setVerticalScrollBarPolicy(22);
        this.usedListScrollPane = new JScrollPane(this.usedList);
        this.usedListScrollPane.setVerticalScrollBarPolicy(22);
        availablePanel.add("Center", this.availableListScrollPane);
        usedPanel.add("Center", this.usedListScrollPane);
        JPanel buttonPanel = this.createButtonPanel();
        buttonPanel.setOpaque(false);
        JPanel upDownPanel = this.createUpDownPanel();
        upDownPanel.setOpaque(false);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)availablePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)usedPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)upDownPanel, gbc);
        this.updateLists();
        gc.addPropertyChangeListener(this);
        gc.getColumnModel().addColumnModelListener(this);
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.addButton = new JButton(Messages.getString("ColumnChooser.ADD_TO_USED_COLUMNS"));
        this.addButton.setOpaque(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnChooser.this.addColumns();
            }
        });
        this.addButton.setEnabled(false);
        this.removeButton = new JButton(Messages.getString("ColumnChooser.REMOVE_FROM_USED_COLUMNS"));
        this.removeButton.setOpaque(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnChooser.this.removeColumns();
            }
        });
        this.removeButton.setEnabled(false);
        this.availableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColumnChooser.this.addButton.setEnabled(ColumnChooser.this.availableList.getSelectedIndex() != -1);
            }
        });
        this.usedList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColumnChooser.this.removeButton.setEnabled(ColumnChooser.this.usedList.getSelectedIndex() != -1);
                int index = ColumnChooser.this.usedList.getSelectedIndex();
                if (index != -1 && index < ColumnChooser.this.usedList.getModel().getSize() - 1) {
                    ColumnChooser.this.downButton.setEnabled(true);
                } else {
                    ColumnChooser.this.downButton.setEnabled(false);
                }
                if (index == 0 || index == -1) {
                    ColumnChooser.this.upButton.setEnabled(false);
                } else {
                    ColumnChooser.this.upButton.setEnabled(true);
                }
            }
        });
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.addButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.removeButton, gbc);
        return panel;
    }

    private JPanel createUpDownPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.upButton = new JButton(Messages.getString("ColumnChooser.MOVE_COLUMN_UP"));
        this.upButton.setOpaque(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnChooser.this.upColumn();
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = new JButton(Messages.getString("ColumnChooser.MOVE_COLUMN_DOWN"));
        this.downButton.setOpaque(false);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnChooser.this.downColumn();
            }
        });
        this.downButton.setEnabled(false);
        this.usedList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColumnChooser.this.upButton.setEnabled(ColumnChooser.this.usedList.getSelectedIndex() != -1 && ColumnChooser.this.usedList.getSelectedIndices().length == 1);
                ColumnChooser.this.downButton.setEnabled(ColumnChooser.this.usedList.getSelectedIndex() != -1 && ColumnChooser.this.usedList.getSelectedIndices().length == 1);
            }
        });
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.upButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.downButton, gbc);
        return panel;
    }

    private void addColumns() {
        for (Object obj : this.availableList.getSelectedValues()) {
            TreeTableColumn col = (TreeTableColumn)obj;
            this.ganttChart.removeAvailableColumn(col);
            IColumnModel colModel = this.ganttChart.getColumnModel();
            if (col instanceof KeyColumn) {
                colModel.setKeyColumn((KeyColumn)col);
                continue;
            }
            colModel.addColumn(col);
        }
        this.updateLists();
    }

    private void removeColumns() {
        for (Object obj : this.usedList.getSelectedValues()) {
            TreeTableColumn col = (TreeTableColumn)obj;
            IColumnModel colModel = this.ganttChart.getColumnModel();
            if (col instanceof KeyColumn) {
                colModel.setKeyColumn(null);
            } else {
                colModel.removeColumn(col);
            }
            this.ganttChart.addAvailableColumn(col);
        }
        this.updateLists();
    }

    private void upColumn() {
        this.move(true);
    }

    private void downColumn() {
        this.move(false);
    }

    private void move(boolean up) {
        int oldIndex = this.usedList.getSelectedIndex();
        int newIndex = -1;
        IColumnModel colModel = this.ganttChart.getColumnModel();
        newIndex = up ? Math.max(0, oldIndex - 1) : Math.min(this.usedList.getModel().getSize(), Math.max(0, oldIndex + 1));
        int newSelectedIndex = newIndex;
        if (this.usedList.getSelectedValue() instanceof KeyColumn) {
            this.ganttChart.setKeyColumnPosition(newIndex);
        } else {
            TreeTableColumn selectedColumn = (TreeTableColumn)this.usedList.getSelectedValue();
            TreeTableColumn column = (TreeTableColumn)this.usedList.getModel().getElementAt(newIndex);
            if (column instanceof KeyColumn) {
                int pos = this.ganttChart.getKeyColumnPosition();
                if (up) {
                    this.ganttChart.setKeyColumnPosition(pos + 1);
                } else {
                    this.ganttChart.setKeyColumnPosition(pos - 1);
                }
            } else {
                int index = colModel.getColumnIndex(selectedColumn);
                if (up) {
                    colModel.moveColumn(index, index - 1);
                } else {
                    colModel.moveColumn(index, index + 1);
                }
            }
        }
        this.updateLists();
        this.usedList.setSelectedIndex(newSelectedIndex);
    }

    public void updateLists() {
        DefaultListModel availableModel = (DefaultListModel)this.availableList.getModel();
        availableModel.removeAllElements();
        for (TreeTableColumn column : this.ganttChart.getAvailableColumns()) {
            availableModel.addElement(column);
        }
        DefaultListModel usedModel = (DefaultListModel)this.usedList.getModel();
        usedModel.removeAllElements();
        IColumnModel colModel = this.ganttChart.getColumnModel();
        int count = colModel.getColumnCount();
        for (int i = 0; i < count; ++i) {
            TreeTableColumn column = colModel.getColumn(i);
            usedModel.addElement(column);
        }
        int pos = this.ganttChart.getKeyColumnPosition();
        KeyColumn keyColumn = colModel.getKeyColumn();
        if (keyColumn != null) {
            if (pos < usedModel.size()) {
                usedModel.insertElementAt(keyColumn, pos);
            } else {
                usedModel.addElement(keyColumn);
            }
        }
    }

    public JList getAvailableList() {
        return this.availableList;
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    public JList getUsedList() {
        return this.usedList;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    protected Border createTitledBorder(String title) {
        return new CompoundBorder(new TitledBorder(title), new EmptyBorder(5, 5, 5, 5));
    }

    public JScrollPane getAvailableListScrollPane() {
        return this.availableListScrollPane;
    }

    public JScrollPane getUsedListScrollPane() {
        return this.usedListScrollPane;
    }

    @Override
    public void columnModelChanged(ColumnModelEvent evt) {
        this.updateLists();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("columnModel")) {
            IColumnModel oldColumnModel = (IColumnModel)evt.getOldValue();
            IColumnModel newColumnModel = (IColumnModel)evt.getNewValue();
            oldColumnModel.removeColumnModelListener(this);
            newColumnModel.addColumnModelListener(this);
        }
    }

    class ColumnListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof KeyColumn) {
                this.setIcon(IconRegistry.getIcon(IconId.KEY_COLUMN));
            } else {
                this.setIcon(IconRegistry.getIcon(IconId.COLUMN));
            }
            return this;
        }
    }
}

