/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy.dateline;

import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.policy.AbstractPolicy;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;

public abstract class AbstractZoomPolicy<T extends IGranularity>
extends AbstractPolicy
implements IZoomPolicy<T> {
    private T[] granularities;

    protected AbstractZoomPolicy(T[] granularities) {
        this.setGranularities((IGranularity[])granularities);
    }

    public void setGranularities(T[] granularities) {
        if (granularities == null) {
            throw new IllegalArgumentException("granularities can not be NULL");
        }
        if (granularities.length == 0) {
            throw new IllegalArgumentException("number of granularities can not be zero");
        }
        this.granularities = granularities;
        this.validate();
    }

    private void validate() {
        Object last = null;
        for (T granularity : this.granularities) {
            if (last == null) {
                last = granularity;
                continue;
            }
            if (granularity.isSmaller(last)) {
                throw new IllegalArgumentException("not a valid sequence (" + granularity + " is smaller than " + last + " but comes after it.");
            }
            last = granularity;
        }
    }

    @Override
    public T getGranularity(int index) {
        if (this.granularities == null) {
            throw new IllegalArgumentException("no granularities have been specified");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index must be larger or equal to 0 but was " + index);
        }
        if (index >= this.granularities.length) {
            throw new IllegalArgumentException("index must be smaller or equal to " + this.granularities.length + " but was " + index);
        }
        return this.granularities[index];
    }

    @Override
    public int getGranularityCount() {
        if (this.granularities == null) {
            throw new IllegalArgumentException("no granularities have been specified");
        }
        return this.granularities.length;
    }

    @Override
    public int getGranularityIndex(T granularity) {
        if (this.granularities == null) {
            throw new IllegalArgumentException("no granularities have been specified, unable to return an index for the given granularity");
        }
        for (int i = 0; i < this.granularities.length; ++i) {
            if (!this.granularities[i].equals(granularity)) continue;
            return i;
        }
        return -1;
    }
}

