/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.scheduling;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.scheduling.BufferType;
import com.dlsc.flexgantt.model.scheduling.ConstraintViolationMessage;
import com.dlsc.flexgantt.model.scheduling.IConstraint;
import com.dlsc.flexgantt.model.scheduling.IModelValidator;
import com.dlsc.flexgantt.model.scheduling.Violation;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.TimelineObjectPathMessage;
import com.dlsc.flexgantt.util.LabelType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class DefaultModelValidator
implements IModelValidator {
    @Override
    public List<IMessage> validate(IGanttChartModel model) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        Iterator iter = model.getRelationships();
        while (iter.hasNext()) {
            IRelationship rel = iter.next();
            IMessage msg = null;
            msg = rel instanceof IConstraint ? this.validate(model, (IConstraint)rel) : this.validate(model, rel);
            if (msg == null) continue;
            messages.add(msg);
        }
        return messages;
    }

    private IMessage validate(IGanttChartModel model, IRelationship rel) {
        TimelineObjectPath sourcePath = rel.getSourcePath();
        TimelineObjectPath targetPath = rel.getTargetPath();
        Object source = sourcePath.getTimelineObject();
        Object target = targetPath.getTimelineObject();
        ITimeSpan sourceSpan = model.getTimeSpan(source);
        ITimeSpan targetSpan = model.getTimeSpan(target);
        switch (rel.getType()) {
            case END_TO_END: {
                if (sourceSpan.getEndTime() == targetSpan.getEndTime()) break;
                return new TimelineObjectPathMessage(this.createMessageTypeId(rel), this.createViolationText(rel), targetPath);
            }
            case END_TO_START: {
                if (targetSpan.getStartTime() >= sourceSpan.getEndTime()) break;
                return new TimelineObjectPathMessage(this.createMessageTypeId(rel), this.createViolationText(rel), targetPath);
            }
            case START_TO_END: {
                if (sourceSpan.getStartTime() >= targetSpan.getEndTime()) break;
                return new TimelineObjectPathMessage(this.createMessageTypeId(rel), this.createViolationText(rel), targetPath);
            }
            case START_TO_START: {
                if (sourceSpan.getStartTime() == targetSpan.getStartTime()) break;
                return new TimelineObjectPathMessage(this.createMessageTypeId(rel), this.createViolationText(rel), targetPath);
            }
        }
        return null;
    }

    @Override
    public IMessage validate(IGanttChartModel model, IConstraint con) {
        TimelineObjectPath sourcePath = con.getSourcePath();
        TimelineObjectPath targetPath = con.getTargetPath();
        Object source = sourcePath.getTimelineObject();
        Object target = targetPath.getTimelineObject();
        ITimeSpan sourceSpan = model.getTimeSpan(source);
        ITimeSpan targetSpan = model.getTimeSpan(target);
        Violation violation = null;
        switch (con.getType()) {
            case END_TO_END: {
                violation = con.getViolation(sourceSpan.getEndTime(), targetSpan.getEndTime());
                break;
            }
            case END_TO_START: {
                violation = con.getViolation(sourceSpan.getEndTime(), targetSpan.getStartTime());
                break;
            }
            case START_TO_END: {
                violation = con.getViolation(sourceSpan.getStartTime(), targetSpan.getEndTime());
                break;
            }
            case START_TO_START: {
                violation = con.getViolation(sourceSpan.getStartTime(), targetSpan.getStartTime());
            }
        }
        if (violation != null) {
            return new ConstraintViolationMessage(con, violation, this.createMessageTypeId(con), this, this.createViolationText(con, violation), targetPath);
        }
        return null;
    }

    private MessageTypeId createMessageTypeId(IRelationship<?> rel) {
        if (rel instanceof IConstraint) {
            IConstraint con = (IConstraint)rel;
            switch (con.getConstraintType()) {
                case HARD: {
                    return MessageTypeId.ERROR;
                }
                case SOFT: {
                    return MessageTypeId.WARNING;
                }
            }
            return MessageTypeId.ERROR;
        }
        return MessageTypeId.ERROR;
    }

    protected String createViolationText(IRelationship rel) {
        switch (rel.getType()) {
            case END_TO_END: {
                return "End / End Violation";
            }
            case END_TO_START: {
                return "End / Start Violation";
            }
            case START_TO_END: {
                return "Start / End Violation";
            }
            case START_TO_START: {
                return "Start / Start Violation";
            }
        }
        return "Unknown Violation";
    }

    protected String createViolationText(IConstraint con, Violation violation) {
        Object bufferGranularity = con.getBufferGranularity();
        double bufferDuration = con.getBufferDuration();
        BufferType bufferType = con.getBufferType();
        Object targetObject = con.getTargetPath().getTimelineObject();
        String targetName = null;
        if (targetObject instanceof ITimelineObject) {
            targetName = ((ITimelineObject)targetObject).getLabel(LabelType.NAME);
            if (targetName != null && targetName.trim().equals("")) {
                targetName = null;
            } else if (targetName.length() > 30) {
                targetName = targetName.substring(0, 30) + "...";
            }
        }
        StringBuilder sb = new StringBuilder();
        block0 : switch (violation.getCode()) {
            case BUFFER_TOO_SMALL: {
                switch (con.getType()) {
                    case END_TO_START: {
                        if (targetName == null) {
                            sb.append("Second activity starts too early.");
                        } else {
                            sb.append(MessageFormat.format("\"{0}\" starts too early.", targetName));
                        }
                        sb.append(MessageFormat.format(" Buffer time must be {0} {1} {2}.", this.getString(bufferType), bufferDuration, this.getName(bufferDuration, (IGranularity<?>)bufferGranularity)));
                        break;
                    }
                    case END_TO_END: {
                        if (targetName == null) {
                            sb.append("Second activity finishes too late.");
                        } else {
                            sb.append(MessageFormat.format("\"{0}\" ends too early.", targetName));
                        }
                        sb.append(MessageFormat.format(" Buffer time must be {0} {1} {2}.", this.getString(bufferType), bufferDuration, this.getName(bufferDuration, (IGranularity<?>)bufferGranularity)));
                        break;
                    }
                    case START_TO_END: {
                        if (targetName == null) {
                            sb.append("Second activity finishes too late.");
                        } else {
                            sb.append(MessageFormat.format("\"{0}\" finishes too early.", targetName));
                        }
                        sb.append(MessageFormat.format(" Buffer time must be {0} {1} {2}.", this.getString(bufferType), bufferDuration, this.getName(bufferDuration, (IGranularity<?>)bufferGranularity)));
                        break;
                    }
                    case START_TO_START: {
                        if (targetName == null) {
                            sb.append("Second activity starts too early.");
                        } else {
                            sb.append(MessageFormat.format("\"{0}\" starts too early.", targetName));
                        }
                        sb.append(MessageFormat.format(" Buffer time must be {0} {1} {2}.", this.getString(bufferType), bufferDuration, this.getName(bufferDuration, (IGranularity<?>)bufferGranularity)));
                    }
                }
                break;
            }
            case BUFFER_TOO_LARGE: {
                switch (con.getType()) {
                    case END_TO_START: {
                        if (targetName == null) {
                            sb.append("Second activity starts too late.");
                        } else {
                            sb.append(MessageFormat.format("\"{0}\" starts too late.", targetName));
                        }
                        sb.append(MessageFormat.format(" Buffer time must be {0} {1} {2}.", this.getString(bufferType), bufferDuration, this.getName(bufferDuration, (IGranularity<?>)bufferGranularity)));
                        break block0;
                    }
                    case END_TO_END: {
                        if (targetName == null) {
                            sb.append("Second activity ends too late.");
                        } else {
                            sb.append(MessageFormat.format("\"{0}\" ends too late.", targetName));
                        }
                        sb.append(MessageFormat.format(" Buffer time must be {0} {1} {2}.", this.getString(bufferType), bufferDuration, this.getName(bufferDuration, (IGranularity<?>)bufferGranularity)));
                        break block0;
                    }
                    case START_TO_END: {
                        if (targetName == null) {
                            sb.append("Second activity finishes too early.");
                        } else {
                            sb.append(MessageFormat.format("\"{0}\" finishes too early.", targetName));
                        }
                        sb.append(MessageFormat.format(" Buffer time must be {0} {1} {2}.", this.getString(bufferType), bufferDuration, this.getName(bufferDuration, (IGranularity<?>)bufferGranularity)));
                        break block0;
                    }
                    case START_TO_START: {
                        if (targetName == null) {
                            sb.append("Second activity starts too late.");
                        } else {
                            sb.append(MessageFormat.format("\"{0}\" starts too late.", targetName));
                        }
                        sb.append(MessageFormat.format(" Buffer time must be {0} {1} {2}.", this.getString(bufferType), bufferDuration, this.getName(bufferDuration, (IGranularity<?>)bufferGranularity)));
                    }
                }
            }
        }
        return sb.toString();
    }

    private Object getString(BufferType type) {
        switch (type) {
            case EXACTLY: {
                return "exactly";
            }
            case LESS_OR_EXACTLY: {
                return "less than or exactly";
            }
            case LESS_THAN: {
                return "less than";
            }
            case MORE_OR_EXACTLY: {
                return "more than or exactly";
            }
            case MORE_THAN: {
                return "more than";
            }
        }
        return "";
    }

    private Object getName(double count, IGranularity<?> g) {
        if (!Locale.getDefault().getDisplayLanguage().equals(Locale.GERMAN)) {
            if (count == 1.0) {
                return g.getSingularName().toLowerCase();
            }
            return g.getName().toLowerCase();
        }
        return g.getName();
    }
}

